package io.fabric8.knative.eventing.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class BrokerSpecBuilder extends BrokerSpecFluentImpl<BrokerSpecBuilder> implements VisitableBuilder<BrokerSpec,BrokerSpecBuilder>{

    BrokerSpecFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public BrokerSpecBuilder(){
            this(true);
    }
    public BrokerSpecBuilder(Boolean validationEnabled){
            this(new BrokerSpec(), validationEnabled);
    }
    public BrokerSpecBuilder(BrokerSpecFluent<?> fluent){
            this(fluent, true);
    }
    public BrokerSpecBuilder(BrokerSpecFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new BrokerSpec(), validationEnabled);
    }
    public BrokerSpecBuilder(BrokerSpecFluent<?> fluent,BrokerSpec instance){
            this(fluent, instance, true);
    }
    public BrokerSpecBuilder(BrokerSpecFluent<?> fluent,BrokerSpec instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withChannelTemplate(instance.getChannelTemplate()); 
            fluent.withChannelTemplateSpec(instance.getChannelTemplateSpec()); 
            this.validationEnabled = validationEnabled; 
    }
    public BrokerSpecBuilder(BrokerSpec instance){
            this(instance,true);
    }
    public BrokerSpecBuilder(BrokerSpec instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withChannelTemplate(instance.getChannelTemplate()); 
            this.withChannelTemplateSpec(instance.getChannelTemplateSpec()); 
            this.validationEnabled = validationEnabled; 
    }
    public BrokerSpecBuilder(Validator validator){
            this(new BrokerSpec(), true);
    }
    public BrokerSpecBuilder(BrokerSpecFluent<?> fluent,BrokerSpec instance,Validator validator){
            this.fluent = fluent; 
            fluent.withChannelTemplate(instance.getChannelTemplate()); 
            fluent.withChannelTemplateSpec(instance.getChannelTemplateSpec()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public BrokerSpecBuilder(BrokerSpec instance,Validator validator){
            this.fluent = this; 
            this.withChannelTemplate(instance.getChannelTemplate()); 
            this.withChannelTemplateSpec(instance.getChannelTemplateSpec()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public BrokerSpec build(){
            BrokerSpec buildable = new BrokerSpec(fluent.getChannelTemplate(),fluent.getChannelTemplateSpec());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable, validator);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            BrokerSpecBuilder that = (BrokerSpecBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
