package io.fabric8.knative.eventing.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class ChannelSpecBuilder extends ChannelSpecFluentImpl<ChannelSpecBuilder> implements VisitableBuilder<ChannelSpec,ChannelSpecBuilder>{

    ChannelSpecFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public ChannelSpecBuilder(){
            this(true);
    }
    public ChannelSpecBuilder(Boolean validationEnabled){
            this(new ChannelSpec(), validationEnabled);
    }
    public ChannelSpecBuilder(ChannelSpecFluent<?> fluent){
            this(fluent, true);
    }
    public ChannelSpecBuilder(ChannelSpecFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new ChannelSpec(), validationEnabled);
    }
    public ChannelSpecBuilder(ChannelSpecFluent<?> fluent,ChannelSpec instance){
            this(fluent, instance, true);
    }
    public ChannelSpecBuilder(ChannelSpecFluent<?> fluent,ChannelSpec instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withArguments(instance.getArguments()); 
            fluent.withGeneration(instance.getGeneration()); 
            fluent.withProvisioner(instance.getProvisioner()); 
            fluent.withSubscribable(instance.getSubscribable()); 
            this.validationEnabled = validationEnabled; 
    }
    public ChannelSpecBuilder(ChannelSpec instance){
            this(instance,true);
    }
    public ChannelSpecBuilder(ChannelSpec instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withArguments(instance.getArguments()); 
            this.withGeneration(instance.getGeneration()); 
            this.withProvisioner(instance.getProvisioner()); 
            this.withSubscribable(instance.getSubscribable()); 
            this.validationEnabled = validationEnabled; 
    }
    public ChannelSpecBuilder(Validator validator){
            this(new ChannelSpec(), true);
    }
    public ChannelSpecBuilder(ChannelSpecFluent<?> fluent,ChannelSpec instance,Validator validator){
            this.fluent = fluent; 
            fluent.withArguments(instance.getArguments()); 
            fluent.withGeneration(instance.getGeneration()); 
            fluent.withProvisioner(instance.getProvisioner()); 
            fluent.withSubscribable(instance.getSubscribable()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public ChannelSpecBuilder(ChannelSpec instance,Validator validator){
            this.fluent = this; 
            this.withArguments(instance.getArguments()); 
            this.withGeneration(instance.getGeneration()); 
            this.withProvisioner(instance.getProvisioner()); 
            this.withSubscribable(instance.getSubscribable()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public ChannelSpec build(){
            ChannelSpec buildable = new ChannelSpec(fluent.getArguments(),fluent.getGeneration(),fluent.getProvisioner(),fluent.getSubscribable());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable, validator);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ChannelSpecBuilder that = (ChannelSpecBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
