package io.fabric8.knative.eventing.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class ChannelStatusBuilder extends ChannelStatusFluentImpl<ChannelStatusBuilder> implements VisitableBuilder<ChannelStatus,ChannelStatusBuilder>{

    ChannelStatusFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public ChannelStatusBuilder(){
            this(true);
    }
    public ChannelStatusBuilder(Boolean validationEnabled){
            this(new ChannelStatus(), validationEnabled);
    }
    public ChannelStatusBuilder(ChannelStatusFluent<?> fluent){
            this(fluent, true);
    }
    public ChannelStatusBuilder(ChannelStatusFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new ChannelStatus(), validationEnabled);
    }
    public ChannelStatusBuilder(ChannelStatusFluent<?> fluent,ChannelStatus instance){
            this(fluent, instance, true);
    }
    public ChannelStatusBuilder(ChannelStatusFluent<?> fluent,ChannelStatus instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withAddress(instance.getAddress()); 
            fluent.withConditions(instance.getConditions()); 
            fluent.withInternal(instance.getInternal()); 
            fluent.withObservedGeneration(instance.getObservedGeneration()); 
            fluent.withSubscribablestatus(instance.getSubscribablestatus()); 
            this.validationEnabled = validationEnabled; 
    }
    public ChannelStatusBuilder(ChannelStatus instance){
            this(instance,true);
    }
    public ChannelStatusBuilder(ChannelStatus instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withAddress(instance.getAddress()); 
            this.withConditions(instance.getConditions()); 
            this.withInternal(instance.getInternal()); 
            this.withObservedGeneration(instance.getObservedGeneration()); 
            this.withSubscribablestatus(instance.getSubscribablestatus()); 
            this.validationEnabled = validationEnabled; 
    }
    public ChannelStatusBuilder(Validator validator){
            this(new ChannelStatus(), true);
    }
    public ChannelStatusBuilder(ChannelStatusFluent<?> fluent,ChannelStatus instance,Validator validator){
            this.fluent = fluent; 
            fluent.withAddress(instance.getAddress()); 
            fluent.withConditions(instance.getConditions()); 
            fluent.withInternal(instance.getInternal()); 
            fluent.withObservedGeneration(instance.getObservedGeneration()); 
            fluent.withSubscribablestatus(instance.getSubscribablestatus()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public ChannelStatusBuilder(ChannelStatus instance,Validator validator){
            this.fluent = this; 
            this.withAddress(instance.getAddress()); 
            this.withConditions(instance.getConditions()); 
            this.withInternal(instance.getInternal()); 
            this.withObservedGeneration(instance.getObservedGeneration()); 
            this.withSubscribablestatus(instance.getSubscribablestatus()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public ChannelStatus build(){
            ChannelStatus buildable = new ChannelStatus(fluent.getAddress(),fluent.getConditions(),fluent.getInternal(),fluent.getObservedGeneration(),fluent.getSubscribablestatus());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable, validator);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ChannelStatusBuilder that = (ChannelStatusBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
