package io.fabric8.knative.eventing.v1alpha1;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.util.LinkedHashMap;
import io.fabric8.knative.duck.v1alpha1.AddressableFluentImpl;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.knative.duck.v1alpha1.SubscribableStatusFluentImpl;
import io.fabric8.knative.v1.Condition;
import io.fabric8.knative.duck.v1alpha1.SubscribableStatus;
import io.fabric8.knative.duck.v1alpha1.SubscribableStatusBuilder;
import io.fabric8.knative.v1.ConditionBuilder;
import io.fabric8.knative.v1.ConditionFluentImpl;
import io.fabric8.knative.duck.v1alpha1.AddressableBuilder;
import java.lang.Long;
import io.fabric8.knative.duck.v1alpha1.Addressable;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

public class ChannelStatusFluentImpl<A extends ChannelStatusFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements ChannelStatusFluent<A>{

    private AddressableBuilder address;
    private List<ConditionBuilder> conditions;
    private Map<String,Object> internal;
    private Long observedGeneration;
    private SubscribableStatusBuilder subscribablestatus;

    public ChannelStatusFluentImpl(){
    }
    public ChannelStatusFluentImpl(ChannelStatus instance){
            this.withAddress(instance.getAddress()); 
            this.withConditions(instance.getConditions()); 
            this.withInternal(instance.getInternal()); 
            this.withObservedGeneration(instance.getObservedGeneration()); 
            this.withSubscribablestatus(instance.getSubscribablestatus()); 
    }

    
/**
 * This method has been deprecated, please use method buildAddress instead.
 * @return The buildable object.
 */
@Deprecated public Addressable getAddress(){
            return this.address!=null?this.address.build():null;
    }

    public Addressable buildAddress(){
            return this.address!=null?this.address.build():null;
    }

    public A withAddress(Addressable address){
            _visitables.get("address").remove(this.address);
            if (address!=null){ this.address= new AddressableBuilder(address); _visitables.get("address").add(this.address);} return (A) this;
    }

    public Boolean hasAddress(){
            return this.address != null;
    }

    public ChannelStatusFluent.AddressNested<A> withNewAddress(){
            return new AddressNestedImpl();
    }

    public ChannelStatusFluent.AddressNested<A> withNewAddressLike(Addressable item){
            return new AddressNestedImpl(item);
    }

    public ChannelStatusFluent.AddressNested<A> editAddress(){
            return withNewAddressLike(getAddress());
    }

    public ChannelStatusFluent.AddressNested<A> editOrNewAddress(){
            return withNewAddressLike(getAddress() != null ? getAddress(): new AddressableBuilder().build());
    }

    public ChannelStatusFluent.AddressNested<A> editOrNewAddressLike(Addressable item){
            return withNewAddressLike(getAddress() != null ? getAddress(): item);
    }

    public A addToConditions(int index,Condition item){
            if (this.conditions == null) {this.conditions = new ArrayList<ConditionBuilder>();}
            ConditionBuilder builder = new ConditionBuilder(item);_visitables.get("conditions").add(index >= 0 ? index : _visitables.get("conditions").size(), builder);this.conditions.add(index >= 0 ? index : conditions.size(), builder); return (A)this;
    }

    public A setToConditions(int index,Condition item){
            if (this.conditions == null) {this.conditions = new ArrayList<ConditionBuilder>();}
            ConditionBuilder builder = new ConditionBuilder(item);
            if (index < 0 || index >= _visitables.get("conditions").size()) { _visitables.get("conditions").add(builder); } else { _visitables.get("conditions").set(index, builder);}
            if (index < 0 || index >= conditions.size()) { conditions.add(builder); } else { conditions.set(index, builder);}
             return (A)this;
    }

    public A addToConditions(Condition... items){
            if (this.conditions == null) {this.conditions = new ArrayList<ConditionBuilder>();}
            for (Condition item : items) {ConditionBuilder builder = new ConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
    }

    public A addAllToConditions(Collection<Condition> items){
            if (this.conditions == null) {this.conditions = new ArrayList<ConditionBuilder>();}
            for (Condition item : items) {ConditionBuilder builder = new ConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
    }

    public A removeFromConditions(Condition... items){
            for (Condition item : items) {ConditionBuilder builder = new ConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
    }

    public A removeAllFromConditions(Collection<Condition> items){
            for (Condition item : items) {ConditionBuilder builder = new ConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildConditions instead.
 * @return The buildable object.
 */
@Deprecated public List<Condition> getConditions(){
            return build(conditions);
    }

    public List<Condition> buildConditions(){
            return build(conditions);
    }

    public Condition buildCondition(int index){
            return this.conditions.get(index).build();
    }

    public Condition buildFirstCondition(){
            return this.conditions.get(0).build();
    }

    public Condition buildLastCondition(){
            return this.conditions.get(conditions.size() - 1).build();
    }

    public Condition buildMatchingCondition(io.fabric8.kubernetes.api.builder.Predicate<ConditionBuilder> predicate){
            for (ConditionBuilder item: conditions) { if(predicate.apply(item)){return item.build();} } return null;
    }

    public Boolean hasMatchingCondition(io.fabric8.kubernetes.api.builder.Predicate<ConditionBuilder> predicate){
            for (ConditionBuilder item: conditions) { if(predicate.apply(item)){return true;} } return false;
    }

    public A withConditions(List<Condition> conditions){
            if (this.conditions != null) { _visitables.get("conditions").removeAll(this.conditions);}
            if (conditions != null) {this.conditions = new ArrayList<ConditionBuilder>(); for (Condition item : conditions){this.addToConditions(item);}} else { this.conditions = new ArrayList<ConditionBuilder>();} return (A) this;
    }

    public A withConditions(Condition... conditions){
            if (this.conditions != null) {this.conditions.clear();}
            if (conditions != null) {for (Condition item :conditions){ this.addToConditions(item);}} return (A) this;
    }

    public Boolean hasConditions(){
            return conditions != null && !conditions.isEmpty();
    }

    public ChannelStatusFluent.ConditionsNested<A> addNewCondition(){
            return new ConditionsNestedImpl();
    }

    public ChannelStatusFluent.ConditionsNested<A> addNewConditionLike(Condition item){
            return new ConditionsNestedImpl(-1, item);
    }

    public ChannelStatusFluent.ConditionsNested<A> setNewConditionLike(int index,Condition item){
            return new ConditionsNestedImpl(index, item);
    }

    public ChannelStatusFluent.ConditionsNested<A> editCondition(int index){
            if (conditions.size() <= index) throw new RuntimeException("Can't edit conditions. Index exceeds size.");
            return setNewConditionLike(index, buildCondition(index));
    }

    public ChannelStatusFluent.ConditionsNested<A> editFirstCondition(){
            if (conditions.size() == 0) throw new RuntimeException("Can't edit first conditions. The list is empty.");
            return setNewConditionLike(0, buildCondition(0));
    }

    public ChannelStatusFluent.ConditionsNested<A> editLastCondition(){
            int index = conditions.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last conditions. The list is empty.");
            return setNewConditionLike(index, buildCondition(index));
    }

    public ChannelStatusFluent.ConditionsNested<A> editMatchingCondition(io.fabric8.kubernetes.api.builder.Predicate<ConditionBuilder> predicate){
            int index = -1;
            for (int i=0;i<conditions.size();i++) { 
            if (predicate.apply(conditions.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching conditions. No match found.");
            return setNewConditionLike(index, buildCondition(index));
    }

    public A addToInternal(String key,Object value){
            if(this.internal == null && key != null && value != null) { this.internal = new LinkedHashMap<String,Object>(); }
            if(key != null && value != null) {this.internal.put(key, value);} return (A)this;
    }

    public A addToInternal(Map<String,Object> map){
            if(this.internal == null && map != null) { this.internal = new LinkedHashMap<String,Object>(); }
            if(map != null) { this.internal.putAll(map);} return (A)this;
    }

    public A removeFromInternal(String key){
            if(this.internal == null) { return (A) this; }
            if(key != null && this.internal != null) {this.internal.remove(key);} return (A)this;
    }

    public A removeFromInternal(Map<String,Object> map){
            if(this.internal == null) { return (A) this; }
            if(map != null) { for(Object key : map.keySet()) {if (this.internal != null){this.internal.remove(key);}}} return (A)this;
    }

    public Map<String,Object> getInternal(){
            return this.internal;
    }

    public A withInternal(Map<String,Object> internal){
            if (internal == null) { this.internal =  new LinkedHashMap<String,Object>();} else {this.internal = new LinkedHashMap<String,Object>(internal);} return (A) this;
    }

    public Boolean hasInternal(){
            return this.internal != null;
    }

    public Long getObservedGeneration(){
            return this.observedGeneration;
    }

    public A withObservedGeneration(Long observedGeneration){
            this.observedGeneration=observedGeneration; return (A) this;
    }

    public Boolean hasObservedGeneration(){
            return this.observedGeneration != null;
    }

    
/**
 * This method has been deprecated, please use method buildSubscribablestatus instead.
 * @return The buildable object.
 */
@Deprecated public SubscribableStatus getSubscribablestatus(){
            return this.subscribablestatus!=null?this.subscribablestatus.build():null;
    }

    public SubscribableStatus buildSubscribablestatus(){
            return this.subscribablestatus!=null?this.subscribablestatus.build():null;
    }

    public A withSubscribablestatus(SubscribableStatus subscribablestatus){
            _visitables.get("subscribablestatus").remove(this.subscribablestatus);
            if (subscribablestatus!=null){ this.subscribablestatus= new SubscribableStatusBuilder(subscribablestatus); _visitables.get("subscribablestatus").add(this.subscribablestatus);} return (A) this;
    }

    public Boolean hasSubscribablestatus(){
            return this.subscribablestatus != null;
    }

    public ChannelStatusFluent.SubscribablestatusNested<A> withNewSubscribablestatus(){
            return new SubscribablestatusNestedImpl();
    }

    public ChannelStatusFluent.SubscribablestatusNested<A> withNewSubscribablestatusLike(SubscribableStatus item){
            return new SubscribablestatusNestedImpl(item);
    }

    public ChannelStatusFluent.SubscribablestatusNested<A> editSubscribablestatus(){
            return withNewSubscribablestatusLike(getSubscribablestatus());
    }

    public ChannelStatusFluent.SubscribablestatusNested<A> editOrNewSubscribablestatus(){
            return withNewSubscribablestatusLike(getSubscribablestatus() != null ? getSubscribablestatus(): new SubscribableStatusBuilder().build());
    }

    public ChannelStatusFluent.SubscribablestatusNested<A> editOrNewSubscribablestatusLike(SubscribableStatus item){
            return withNewSubscribablestatusLike(getSubscribablestatus() != null ? getSubscribablestatus(): item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ChannelStatusFluentImpl that = (ChannelStatusFluentImpl) o;
            if (address != null ? !address.equals(that.address) :that.address != null) return false;
            if (conditions != null ? !conditions.equals(that.conditions) :that.conditions != null) return false;
            if (internal != null ? !internal.equals(that.internal) :that.internal != null) return false;
            if (observedGeneration != null ? !observedGeneration.equals(that.observedGeneration) :that.observedGeneration != null) return false;
            if (subscribablestatus != null ? !subscribablestatus.equals(that.subscribablestatus) :that.subscribablestatus != null) return false;
            return true;
    }


    public class AddressNestedImpl<N> extends AddressableFluentImpl<ChannelStatusFluent.AddressNested<N>> implements ChannelStatusFluent.AddressNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final AddressableBuilder builder;
    
            AddressNestedImpl(Addressable item){
                    this.builder = new AddressableBuilder(this, item);
            }
            AddressNestedImpl(){
                    this.builder = new AddressableBuilder(this);
            }
    
    public N and(){
            return (N) ChannelStatusFluentImpl.this.withAddress(builder.build());
    }
    public N endAddress(){
            return and();
    }

}
    public class ConditionsNestedImpl<N> extends ConditionFluentImpl<ChannelStatusFluent.ConditionsNested<N>> implements ChannelStatusFluent.ConditionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ConditionBuilder builder;
        private final int index;
    
            ConditionsNestedImpl(int index,Condition item){
                    this.index = index;
                    this.builder = new ConditionBuilder(this, item);
            }
            ConditionsNestedImpl(){
                    this.index = -1;
                    this.builder = new ConditionBuilder(this);
            }
    
    public N and(){
            return (N) ChannelStatusFluentImpl.this.setToConditions(index, builder.build());
    }
    public N endCondition(){
            return and();
    }

}
    public class SubscribablestatusNestedImpl<N> extends SubscribableStatusFluentImpl<ChannelStatusFluent.SubscribablestatusNested<N>> implements ChannelStatusFluent.SubscribablestatusNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final SubscribableStatusBuilder builder;
    
            SubscribablestatusNestedImpl(SubscribableStatus item){
                    this.builder = new SubscribableStatusBuilder(this, item);
            }
            SubscribablestatusNestedImpl(){
                    this.builder = new SubscribableStatusBuilder(this);
            }
    
    public N and(){
            return (N) ChannelStatusFluentImpl.this.withSubscribablestatus(builder.build());
    }
    public N endSubscribablestatus(){
            return and();
    }

}


}
