package io.fabric8.knative.eventing.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class ClusterChannelProvisionerStatusBuilder extends ClusterChannelProvisionerStatusFluentImpl<ClusterChannelProvisionerStatusBuilder> implements VisitableBuilder<ClusterChannelProvisionerStatus,ClusterChannelProvisionerStatusBuilder>{

    ClusterChannelProvisionerStatusFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public ClusterChannelProvisionerStatusBuilder(){
            this(true);
    }
    public ClusterChannelProvisionerStatusBuilder(Boolean validationEnabled){
            this(new ClusterChannelProvisionerStatus(), validationEnabled);
    }
    public ClusterChannelProvisionerStatusBuilder(ClusterChannelProvisionerStatusFluent<?> fluent){
            this(fluent, true);
    }
    public ClusterChannelProvisionerStatusBuilder(ClusterChannelProvisionerStatusFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new ClusterChannelProvisionerStatus(), validationEnabled);
    }
    public ClusterChannelProvisionerStatusBuilder(ClusterChannelProvisionerStatusFluent<?> fluent,ClusterChannelProvisionerStatus instance){
            this(fluent, instance, true);
    }
    public ClusterChannelProvisionerStatusBuilder(ClusterChannelProvisionerStatusFluent<?> fluent,ClusterChannelProvisionerStatus instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withConditions(instance.getConditions()); 
            fluent.withObservedGeneration(instance.getObservedGeneration()); 
            this.validationEnabled = validationEnabled; 
    }
    public ClusterChannelProvisionerStatusBuilder(ClusterChannelProvisionerStatus instance){
            this(instance,true);
    }
    public ClusterChannelProvisionerStatusBuilder(ClusterChannelProvisionerStatus instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withConditions(instance.getConditions()); 
            this.withObservedGeneration(instance.getObservedGeneration()); 
            this.validationEnabled = validationEnabled; 
    }
    public ClusterChannelProvisionerStatusBuilder(Validator validator){
            this(new ClusterChannelProvisionerStatus(), true);
    }
    public ClusterChannelProvisionerStatusBuilder(ClusterChannelProvisionerStatusFluent<?> fluent,ClusterChannelProvisionerStatus instance,Validator validator){
            this.fluent = fluent; 
            fluent.withConditions(instance.getConditions()); 
            fluent.withObservedGeneration(instance.getObservedGeneration()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public ClusterChannelProvisionerStatusBuilder(ClusterChannelProvisionerStatus instance,Validator validator){
            this.fluent = this; 
            this.withConditions(instance.getConditions()); 
            this.withObservedGeneration(instance.getObservedGeneration()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public ClusterChannelProvisionerStatus build(){
            ClusterChannelProvisionerStatus buildable = new ClusterChannelProvisionerStatus(fluent.getConditions(),fluent.getObservedGeneration());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable, validator);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ClusterChannelProvisionerStatusBuilder that = (ClusterChannelProvisionerStatusBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
