package io.fabric8.knative.serving.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class RevisionStatusBuilder extends RevisionStatusFluentImpl<RevisionStatusBuilder> implements VisitableBuilder<RevisionStatus,RevisionStatusBuilder>{

    RevisionStatusFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public RevisionStatusBuilder(){
            this(true);
    }
    public RevisionStatusBuilder(Boolean validationEnabled){
            this(new RevisionStatus(), validationEnabled);
    }
    public RevisionStatusBuilder(RevisionStatusFluent<?> fluent){
            this(fluent, true);
    }
    public RevisionStatusBuilder(RevisionStatusFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new RevisionStatus(), validationEnabled);
    }
    public RevisionStatusBuilder(RevisionStatusFluent<?> fluent,RevisionStatus instance){
            this(fluent, instance, true);
    }
    public RevisionStatusBuilder(RevisionStatusFluent<?> fluent,RevisionStatus instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withConditions(instance.getConditions()); 
            fluent.withLogUrl(instance.getLogUrl()); 
            fluent.withObservedGeneration(instance.getObservedGeneration()); 
            fluent.withServiceName(instance.getServiceName()); 
            this.validationEnabled = validationEnabled; 
    }
    public RevisionStatusBuilder(RevisionStatus instance){
            this(instance,true);
    }
    public RevisionStatusBuilder(RevisionStatus instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withConditions(instance.getConditions()); 
            this.withLogUrl(instance.getLogUrl()); 
            this.withObservedGeneration(instance.getObservedGeneration()); 
            this.withServiceName(instance.getServiceName()); 
            this.validationEnabled = validationEnabled; 
    }
    public RevisionStatusBuilder(Validator validator){
            this(new RevisionStatus(), true);
    }
    public RevisionStatusBuilder(RevisionStatusFluent<?> fluent,RevisionStatus instance,Validator validator){
            this.fluent = fluent; 
            fluent.withConditions(instance.getConditions()); 
            fluent.withLogUrl(instance.getLogUrl()); 
            fluent.withObservedGeneration(instance.getObservedGeneration()); 
            fluent.withServiceName(instance.getServiceName()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public RevisionStatusBuilder(RevisionStatus instance,Validator validator){
            this.fluent = this; 
            this.withConditions(instance.getConditions()); 
            this.withLogUrl(instance.getLogUrl()); 
            this.withObservedGeneration(instance.getObservedGeneration()); 
            this.withServiceName(instance.getServiceName()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public RevisionStatus build(){
            RevisionStatus buildable = new RevisionStatus(fluent.getConditions(),fluent.getLogUrl(),fluent.getObservedGeneration(),fluent.getServiceName());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable, validator);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            RevisionStatusBuilder that = (RevisionStatusBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
