package io.fabric8.knative.serving.v1beta1;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.knative.v1.URL;
import io.fabric8.knative.v1.URLBuilder;
import java.lang.Integer;
import io.fabric8.knative.v1.URLFluentImpl;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class TrafficTargetFluentImpl<A extends TrafficTargetFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements TrafficTargetFluent<A>{

    private String configurationName;
    private Boolean latestRevision;
    private Integer percent;
    private String revisionName;
    private String tag;
    private URLBuilder url;

    public TrafficTargetFluentImpl(){
    }
    public TrafficTargetFluentImpl(TrafficTarget instance){
            this.withConfigurationName(instance.getConfigurationName()); 
            this.withLatestRevision(instance.getLatestRevision()); 
            this.withPercent(instance.getPercent()); 
            this.withRevisionName(instance.getRevisionName()); 
            this.withTag(instance.getTag()); 
            this.withUrl(instance.getUrl()); 
    }

    public String getConfigurationName(){
            return this.configurationName;
    }

    public A withConfigurationName(String configurationName){
            this.configurationName=configurationName; return (A) this;
    }

    public Boolean hasConfigurationName(){
            return this.configurationName != null;
    }

    public A withNewConfigurationName(String arg1){
            return (A)withConfigurationName(new String(arg1));
    }

    public A withNewConfigurationName(StringBuilder arg1){
            return (A)withConfigurationName(new String(arg1));
    }

    public A withNewConfigurationName(StringBuffer arg1){
            return (A)withConfigurationName(new String(arg1));
    }

    public Boolean isLatestRevision(){
            return this.latestRevision;
    }

    public A withLatestRevision(Boolean latestRevision){
            this.latestRevision=latestRevision; return (A) this;
    }

    public Boolean hasLatestRevision(){
            return this.latestRevision != null;
    }

    public A withNewLatestRevision(String arg1){
            return (A)withLatestRevision(new Boolean(arg1));
    }

    public A withNewLatestRevision(boolean arg1){
            return (A)withLatestRevision(new Boolean(arg1));
    }

    public Integer getPercent(){
            return this.percent;
    }

    public A withPercent(Integer percent){
            this.percent=percent; return (A) this;
    }

    public Boolean hasPercent(){
            return this.percent != null;
    }

    public String getRevisionName(){
            return this.revisionName;
    }

    public A withRevisionName(String revisionName){
            this.revisionName=revisionName; return (A) this;
    }

    public Boolean hasRevisionName(){
            return this.revisionName != null;
    }

    public A withNewRevisionName(String arg1){
            return (A)withRevisionName(new String(arg1));
    }

    public A withNewRevisionName(StringBuilder arg1){
            return (A)withRevisionName(new String(arg1));
    }

    public A withNewRevisionName(StringBuffer arg1){
            return (A)withRevisionName(new String(arg1));
    }

    public String getTag(){
            return this.tag;
    }

    public A withTag(String tag){
            this.tag=tag; return (A) this;
    }

    public Boolean hasTag(){
            return this.tag != null;
    }

    public A withNewTag(String arg1){
            return (A)withTag(new String(arg1));
    }

    public A withNewTag(StringBuilder arg1){
            return (A)withTag(new String(arg1));
    }

    public A withNewTag(StringBuffer arg1){
            return (A)withTag(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildUrl instead.
 * @return The buildable object.
 */
@Deprecated public URL getUrl(){
            return this.url!=null?this.url.build():null;
    }

    public URL buildUrl(){
            return this.url!=null?this.url.build():null;
    }

    public A withUrl(URL url){
            _visitables.get("url").remove(this.url);
            if (url!=null){ this.url= new URLBuilder(url); _visitables.get("url").add(this.url);} return (A) this;
    }

    public Boolean hasUrl(){
            return this.url != null;
    }

    public TrafficTargetFluent.UrlNested<A> withNewUrl(){
            return new UrlNestedImpl();
    }

    public TrafficTargetFluent.UrlNested<A> withNewUrlLike(URL item){
            return new UrlNestedImpl(item);
    }

    public TrafficTargetFluent.UrlNested<A> editUrl(){
            return withNewUrlLike(getUrl());
    }

    public TrafficTargetFluent.UrlNested<A> editOrNewUrl(){
            return withNewUrlLike(getUrl() != null ? getUrl(): new URLBuilder().build());
    }

    public TrafficTargetFluent.UrlNested<A> editOrNewUrlLike(URL item){
            return withNewUrlLike(getUrl() != null ? getUrl(): item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            TrafficTargetFluentImpl that = (TrafficTargetFluentImpl) o;
            if (configurationName != null ? !configurationName.equals(that.configurationName) :that.configurationName != null) return false;
            if (latestRevision != null ? !latestRevision.equals(that.latestRevision) :that.latestRevision != null) return false;
            if (percent != null ? !percent.equals(that.percent) :that.percent != null) return false;
            if (revisionName != null ? !revisionName.equals(that.revisionName) :that.revisionName != null) return false;
            if (tag != null ? !tag.equals(that.tag) :that.tag != null) return false;
            if (url != null ? !url.equals(that.url) :that.url != null) return false;
            return true;
    }


    public class UrlNestedImpl<N> extends URLFluentImpl<TrafficTargetFluent.UrlNested<N>> implements TrafficTargetFluent.UrlNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final URLBuilder builder;
    
            UrlNestedImpl(URL item){
                    this.builder = new URLBuilder(this, item);
            }
            UrlNestedImpl(){
                    this.builder = new URLBuilder(this);
            }
    
    public N and(){
            return (N) TrafficTargetFluentImpl.this.withUrl(builder.build());
    }
    public N endUrl(){
            return and();
    }

}


}
