package io.fabric8.knative.messaging.v1alpha1;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.knative.duck.v1alpha1.AddressableFluentImpl;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.knative.duck.v1alpha1.SubscribableStatusFluentImpl;
import io.fabric8.knative.v1.Condition;
import io.fabric8.knative.duck.v1alpha1.SubscribableStatus;
import io.fabric8.knative.duck.v1alpha1.SubscribableStatusBuilder;
import io.fabric8.knative.v1.ConditionBuilder;
import io.fabric8.knative.v1.ConditionFluentImpl;
import io.fabric8.knative.duck.v1alpha1.AddressableBuilder;
import java.lang.Long;
import io.fabric8.knative.duck.v1alpha1.Addressable;
import java.util.Collection;
import java.lang.Object;

public class InMemoryChannelStatusFluentImpl<A extends InMemoryChannelStatusFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements InMemoryChannelStatusFluent<A>{

    private AddressableBuilder address;
    private List<ConditionBuilder> conditions;
    private Long observedGeneration;
    private SubscribableStatusBuilder subscribablestatus;

    public InMemoryChannelStatusFluentImpl(){
    }
    public InMemoryChannelStatusFluentImpl(InMemoryChannelStatus instance){
            this.withAddress(instance.getAddress()); 
            this.withConditions(instance.getConditions()); 
            this.withObservedGeneration(instance.getObservedGeneration()); 
            this.withSubscribablestatus(instance.getSubscribablestatus()); 
    }

    
/**
 * This method has been deprecated, please use method buildAddress instead.
 * @return The buildable object.
 */
@Deprecated public Addressable getAddress(){
            return this.address!=null?this.address.build():null;
    }

    public Addressable buildAddress(){
            return this.address!=null?this.address.build():null;
    }

    public A withAddress(Addressable address){
            _visitables.get("address").remove(this.address);
            if (address!=null){ this.address= new AddressableBuilder(address); _visitables.get("address").add(this.address);} return (A) this;
    }

    public Boolean hasAddress(){
            return this.address != null;
    }

    public InMemoryChannelStatusFluent.AddressNested<A> withNewAddress(){
            return new AddressNestedImpl();
    }

    public InMemoryChannelStatusFluent.AddressNested<A> withNewAddressLike(Addressable item){
            return new AddressNestedImpl(item);
    }

    public InMemoryChannelStatusFluent.AddressNested<A> editAddress(){
            return withNewAddressLike(getAddress());
    }

    public InMemoryChannelStatusFluent.AddressNested<A> editOrNewAddress(){
            return withNewAddressLike(getAddress() != null ? getAddress(): new AddressableBuilder().build());
    }

    public InMemoryChannelStatusFluent.AddressNested<A> editOrNewAddressLike(Addressable item){
            return withNewAddressLike(getAddress() != null ? getAddress(): item);
    }

    public A addToConditions(int index,Condition item){
            if (this.conditions == null) {this.conditions = new ArrayList<ConditionBuilder>();}
            ConditionBuilder builder = new ConditionBuilder(item);_visitables.get("conditions").add(index >= 0 ? index : _visitables.get("conditions").size(), builder);this.conditions.add(index >= 0 ? index : conditions.size(), builder); return (A)this;
    }

    public A setToConditions(int index,Condition item){
            if (this.conditions == null) {this.conditions = new ArrayList<ConditionBuilder>();}
            ConditionBuilder builder = new ConditionBuilder(item);
            if (index < 0 || index >= _visitables.get("conditions").size()) { _visitables.get("conditions").add(builder); } else { _visitables.get("conditions").set(index, builder);}
            if (index < 0 || index >= conditions.size()) { conditions.add(builder); } else { conditions.set(index, builder);}
             return (A)this;
    }

    public A addToConditions(Condition... items){
            if (this.conditions == null) {this.conditions = new ArrayList<ConditionBuilder>();}
            for (Condition item : items) {ConditionBuilder builder = new ConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
    }

    public A addAllToConditions(Collection<Condition> items){
            if (this.conditions == null) {this.conditions = new ArrayList<ConditionBuilder>();}
            for (Condition item : items) {ConditionBuilder builder = new ConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
    }

    public A removeFromConditions(Condition... items){
            for (Condition item : items) {ConditionBuilder builder = new ConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
    }

    public A removeAllFromConditions(Collection<Condition> items){
            for (Condition item : items) {ConditionBuilder builder = new ConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildConditions instead.
 * @return The buildable object.
 */
@Deprecated public List<Condition> getConditions(){
            return build(conditions);
    }

    public List<Condition> buildConditions(){
            return build(conditions);
    }

    public Condition buildCondition(int index){
            return this.conditions.get(index).build();
    }

    public Condition buildFirstCondition(){
            return this.conditions.get(0).build();
    }

    public Condition buildLastCondition(){
            return this.conditions.get(conditions.size() - 1).build();
    }

    public Condition buildMatchingCondition(io.fabric8.kubernetes.api.builder.Predicate<ConditionBuilder> predicate){
            for (ConditionBuilder item: conditions) { if(predicate.apply(item)){return item.build();} } return null;
    }

    public Boolean hasMatchingCondition(io.fabric8.kubernetes.api.builder.Predicate<ConditionBuilder> predicate){
            for (ConditionBuilder item: conditions) { if(predicate.apply(item)){return true;} } return false;
    }

    public A withConditions(List<Condition> conditions){
            if (this.conditions != null) { _visitables.get("conditions").removeAll(this.conditions);}
            if (conditions != null) {this.conditions = new ArrayList<ConditionBuilder>(); for (Condition item : conditions){this.addToConditions(item);}} else { this.conditions = new ArrayList<ConditionBuilder>();} return (A) this;
    }

    public A withConditions(Condition... conditions){
            if (this.conditions != null) {this.conditions.clear();}
            if (conditions != null) {for (Condition item :conditions){ this.addToConditions(item);}} return (A) this;
    }

    public Boolean hasConditions(){
            return conditions != null && !conditions.isEmpty();
    }

    public InMemoryChannelStatusFluent.ConditionsNested<A> addNewCondition(){
            return new ConditionsNestedImpl();
    }

    public InMemoryChannelStatusFluent.ConditionsNested<A> addNewConditionLike(Condition item){
            return new ConditionsNestedImpl(-1, item);
    }

    public InMemoryChannelStatusFluent.ConditionsNested<A> setNewConditionLike(int index,Condition item){
            return new ConditionsNestedImpl(index, item);
    }

    public InMemoryChannelStatusFluent.ConditionsNested<A> editCondition(int index){
            if (conditions.size() <= index) throw new RuntimeException("Can't edit conditions. Index exceeds size.");
            return setNewConditionLike(index, buildCondition(index));
    }

    public InMemoryChannelStatusFluent.ConditionsNested<A> editFirstCondition(){
            if (conditions.size() == 0) throw new RuntimeException("Can't edit first conditions. The list is empty.");
            return setNewConditionLike(0, buildCondition(0));
    }

    public InMemoryChannelStatusFluent.ConditionsNested<A> editLastCondition(){
            int index = conditions.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last conditions. The list is empty.");
            return setNewConditionLike(index, buildCondition(index));
    }

    public InMemoryChannelStatusFluent.ConditionsNested<A> editMatchingCondition(io.fabric8.kubernetes.api.builder.Predicate<ConditionBuilder> predicate){
            int index = -1;
            for (int i=0;i<conditions.size();i++) { 
            if (predicate.apply(conditions.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching conditions. No match found.");
            return setNewConditionLike(index, buildCondition(index));
    }

    public Long getObservedGeneration(){
            return this.observedGeneration;
    }

    public A withObservedGeneration(Long observedGeneration){
            this.observedGeneration=observedGeneration; return (A) this;
    }

    public Boolean hasObservedGeneration(){
            return this.observedGeneration != null;
    }

    
/**
 * This method has been deprecated, please use method buildSubscribablestatus instead.
 * @return The buildable object.
 */
@Deprecated public SubscribableStatus getSubscribablestatus(){
            return this.subscribablestatus!=null?this.subscribablestatus.build():null;
    }

    public SubscribableStatus buildSubscribablestatus(){
            return this.subscribablestatus!=null?this.subscribablestatus.build():null;
    }

    public A withSubscribablestatus(SubscribableStatus subscribablestatus){
            _visitables.get("subscribablestatus").remove(this.subscribablestatus);
            if (subscribablestatus!=null){ this.subscribablestatus= new SubscribableStatusBuilder(subscribablestatus); _visitables.get("subscribablestatus").add(this.subscribablestatus);} return (A) this;
    }

    public Boolean hasSubscribablestatus(){
            return this.subscribablestatus != null;
    }

    public InMemoryChannelStatusFluent.SubscribablestatusNested<A> withNewSubscribablestatus(){
            return new SubscribablestatusNestedImpl();
    }

    public InMemoryChannelStatusFluent.SubscribablestatusNested<A> withNewSubscribablestatusLike(SubscribableStatus item){
            return new SubscribablestatusNestedImpl(item);
    }

    public InMemoryChannelStatusFluent.SubscribablestatusNested<A> editSubscribablestatus(){
            return withNewSubscribablestatusLike(getSubscribablestatus());
    }

    public InMemoryChannelStatusFluent.SubscribablestatusNested<A> editOrNewSubscribablestatus(){
            return withNewSubscribablestatusLike(getSubscribablestatus() != null ? getSubscribablestatus(): new SubscribableStatusBuilder().build());
    }

    public InMemoryChannelStatusFluent.SubscribablestatusNested<A> editOrNewSubscribablestatusLike(SubscribableStatus item){
            return withNewSubscribablestatusLike(getSubscribablestatus() != null ? getSubscribablestatus(): item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            InMemoryChannelStatusFluentImpl that = (InMemoryChannelStatusFluentImpl) o;
            if (address != null ? !address.equals(that.address) :that.address != null) return false;
            if (conditions != null ? !conditions.equals(that.conditions) :that.conditions != null) return false;
            if (observedGeneration != null ? !observedGeneration.equals(that.observedGeneration) :that.observedGeneration != null) return false;
            if (subscribablestatus != null ? !subscribablestatus.equals(that.subscribablestatus) :that.subscribablestatus != null) return false;
            return true;
    }


    public class AddressNestedImpl<N> extends AddressableFluentImpl<InMemoryChannelStatusFluent.AddressNested<N>> implements InMemoryChannelStatusFluent.AddressNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final AddressableBuilder builder;
    
            AddressNestedImpl(Addressable item){
                    this.builder = new AddressableBuilder(this, item);
            }
            AddressNestedImpl(){
                    this.builder = new AddressableBuilder(this);
            }
    
    public N and(){
            return (N) InMemoryChannelStatusFluentImpl.this.withAddress(builder.build());
    }
    public N endAddress(){
            return and();
    }

}
    public class ConditionsNestedImpl<N> extends ConditionFluentImpl<InMemoryChannelStatusFluent.ConditionsNested<N>> implements InMemoryChannelStatusFluent.ConditionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ConditionBuilder builder;
        private final int index;
    
            ConditionsNestedImpl(int index,Condition item){
                    this.index = index;
                    this.builder = new ConditionBuilder(this, item);
            }
            ConditionsNestedImpl(){
                    this.index = -1;
                    this.builder = new ConditionBuilder(this);
            }
    
    public N and(){
            return (N) InMemoryChannelStatusFluentImpl.this.setToConditions(index, builder.build());
    }
    public N endCondition(){
            return and();
    }

}
    public class SubscribablestatusNestedImpl<N> extends SubscribableStatusFluentImpl<InMemoryChannelStatusFluent.SubscribablestatusNested<N>> implements InMemoryChannelStatusFluent.SubscribablestatusNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final SubscribableStatusBuilder builder;
    
            SubscribablestatusNestedImpl(SubscribableStatus item){
                    this.builder = new SubscribableStatusBuilder(this, item);
            }
            SubscribablestatusNestedImpl(){
                    this.builder = new SubscribableStatusBuilder(this);
            }
    
    public N and(){
            return (N) InMemoryChannelStatusFluentImpl.this.withSubscribablestatus(builder.build());
    }
    public N endSubscribablestatus(){
            return and();
    }

}


}
