package io.fabric8.knative.serving.v1beta1;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.VolumeBuilder;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.model.ContainerFluent;
import java.util.List;
import io.fabric8.kubernetes.api.model.VolumeFluent;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.StringBuffer;
import io.fabric8.kubernetes.api.model.Volume;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

public interface RevisionSpecFluent<A extends RevisionSpecFluent<A>> extends Fluent<A>{


    public Long getContainerConcurrency();
    public A withContainerConcurrency(Long containerConcurrency);
    public Boolean hasContainerConcurrency();
    public A addToContainers(int index,Container item);
    public A setToContainers(int index,Container item);
    public A addToContainers(Container... items);
    public A addAllToContainers(Collection<Container> items);
    public A removeFromContainers(Container... items);
    public A removeAllFromContainers(Collection<Container> items);
    
/**
 * This method has been deprecated, please use method buildContainers instead.
 * @return The buildable object.
 */
@Deprecated public List<Container> getContainers();
    public List<Container> buildContainers();
    public Container buildContainer(int index);
    public Container buildFirstContainer();
    public Container buildLastContainer();
    public Container buildMatchingContainer(io.fabric8.kubernetes.api.builder.Predicate<ContainerBuilder> predicate);
    public Boolean hasMatchingContainer(io.fabric8.kubernetes.api.builder.Predicate<ContainerBuilder> predicate);
    public A withContainers(List<Container> containers);
    public A withContainers(Container... containers);
    public Boolean hasContainers();
    public RevisionSpecFluent.ContainersNested<A> addNewContainer();
    public RevisionSpecFluent.ContainersNested<A> addNewContainerLike(Container item);
    public RevisionSpecFluent.ContainersNested<A> setNewContainerLike(int index,Container item);
    public RevisionSpecFluent.ContainersNested<A> editContainer(int index);
    public RevisionSpecFluent.ContainersNested<A> editFirstContainer();
    public RevisionSpecFluent.ContainersNested<A> editLastContainer();
    public RevisionSpecFluent.ContainersNested<A> editMatchingContainer(io.fabric8.kubernetes.api.builder.Predicate<ContainerBuilder> predicate);
    public String getServiceAccountName();
    public A withServiceAccountName(String serviceAccountName);
    public Boolean hasServiceAccountName();
    public A withNewServiceAccountName(String arg1);
    public A withNewServiceAccountName(StringBuilder arg1);
    public A withNewServiceAccountName(StringBuffer arg1);
    public Long getTimeoutSeconds();
    public A withTimeoutSeconds(Long timeoutSeconds);
    public Boolean hasTimeoutSeconds();
    public A addToVolumes(int index,Volume item);
    public A setToVolumes(int index,Volume item);
    public A addToVolumes(Volume... items);
    public A addAllToVolumes(Collection<Volume> items);
    public A removeFromVolumes(Volume... items);
    public A removeAllFromVolumes(Collection<Volume> items);
    
/**
 * This method has been deprecated, please use method buildVolumes instead.
 * @return The buildable object.
 */
@Deprecated public List<Volume> getVolumes();
    public List<Volume> buildVolumes();
    public Volume buildVolume(int index);
    public Volume buildFirstVolume();
    public Volume buildLastVolume();
    public Volume buildMatchingVolume(io.fabric8.kubernetes.api.builder.Predicate<VolumeBuilder> predicate);
    public Boolean hasMatchingVolume(io.fabric8.kubernetes.api.builder.Predicate<VolumeBuilder> predicate);
    public A withVolumes(List<Volume> volumes);
    public A withVolumes(Volume... volumes);
    public Boolean hasVolumes();
    public RevisionSpecFluent.VolumesNested<A> addNewVolume();
    public RevisionSpecFluent.VolumesNested<A> addNewVolumeLike(Volume item);
    public RevisionSpecFluent.VolumesNested<A> setNewVolumeLike(int index,Volume item);
    public RevisionSpecFluent.VolumesNested<A> editVolume(int index);
    public RevisionSpecFluent.VolumesNested<A> editFirstVolume();
    public RevisionSpecFluent.VolumesNested<A> editLastVolume();
    public RevisionSpecFluent.VolumesNested<A> editMatchingVolume(io.fabric8.kubernetes.api.builder.Predicate<VolumeBuilder> predicate);

    public interface ContainersNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ContainerFluent<RevisionSpecFluent.ContainersNested<N>>{

        
    public N and();    public N endContainer();
}
    public interface VolumesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,VolumeFluent<RevisionSpecFluent.VolumesNested<N>>{

        
    public N and();    public N endVolume();
}


}
