package io.fabric8.knative.duck.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class AddressableBuilder extends AddressableFluentImpl<AddressableBuilder> implements VisitableBuilder<Addressable,AddressableBuilder>{

    AddressableFluent<?> fluent;
    Boolean validationEnabled;

    public AddressableBuilder(){
            this(true);
    }
    public AddressableBuilder(Boolean validationEnabled){
            this(new Addressable(), validationEnabled);
    }
    public AddressableBuilder(AddressableFluent<?> fluent){
            this(fluent, true);
    }
    public AddressableBuilder(AddressableFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new Addressable(), validationEnabled);
    }
    public AddressableBuilder(AddressableFluent<?> fluent,Addressable instance){
            this(fluent, instance, true);
    }
    public AddressableBuilder(AddressableFluent<?> fluent,Addressable instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withHostname(instance.getHostname()); 
            fluent.withUrl(instance.getUrl()); 
            this.validationEnabled = validationEnabled; 
    }
    public AddressableBuilder(Addressable instance){
            this(instance,true);
    }
    public AddressableBuilder(Addressable instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withHostname(instance.getHostname()); 
            this.withUrl(instance.getUrl()); 
            this.validationEnabled = validationEnabled; 
    }

    public Addressable build(){
            Addressable buildable = new Addressable(fluent.getHostname(),fluent.getUrl());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            AddressableBuilder that = (AddressableBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
