package io.fabric8.knative.eventing.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class TriggerStatusBuilder extends TriggerStatusFluentImpl<TriggerStatusBuilder> implements VisitableBuilder<TriggerStatus,TriggerStatusBuilder>{

    TriggerStatusFluent<?> fluent;
    Boolean validationEnabled;

    public TriggerStatusBuilder(){
            this(true);
    }
    public TriggerStatusBuilder(Boolean validationEnabled){
            this(new TriggerStatus(), validationEnabled);
    }
    public TriggerStatusBuilder(TriggerStatusFluent<?> fluent){
            this(fluent, true);
    }
    public TriggerStatusBuilder(TriggerStatusFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new TriggerStatus(), validationEnabled);
    }
    public TriggerStatusBuilder(TriggerStatusFluent<?> fluent,TriggerStatus instance){
            this(fluent, instance, true);
    }
    public TriggerStatusBuilder(TriggerStatusFluent<?> fluent,TriggerStatus instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withConditions(instance.getConditions()); 
            fluent.withObservedGeneration(instance.getObservedGeneration()); 
            fluent.withSubscriberURI(instance.getSubscriberURI()); 
            this.validationEnabled = validationEnabled; 
    }
    public TriggerStatusBuilder(TriggerStatus instance){
            this(instance,true);
    }
    public TriggerStatusBuilder(TriggerStatus instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withConditions(instance.getConditions()); 
            this.withObservedGeneration(instance.getObservedGeneration()); 
            this.withSubscriberURI(instance.getSubscriberURI()); 
            this.validationEnabled = validationEnabled; 
    }

    public TriggerStatus build(){
            TriggerStatus buildable = new TriggerStatus(fluent.getConditions(),fluent.getObservedGeneration(),fluent.getSubscriberURI());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            TriggerStatusBuilder that = (TriggerStatusBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
