package io.fabric8.knative.messaging.v1alpha1;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface SequenceListFluent<A extends SequenceListFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public A addToItems(int index,Sequence item);
    public A setToItems(int index,Sequence item);
    public A addToItems(Sequence... items);
    public A addAllToItems(Collection<Sequence> items);
    public A removeFromItems(Sequence... items);
    public A removeAllFromItems(Collection<Sequence> items);
    
/**
 * This method has been deprecated, please use method buildItems instead.
 * @return The buildable object.
 */
@Deprecated public List<Sequence> getItems();
    public List<Sequence> buildItems();
    public Sequence buildItem(int index);
    public Sequence buildFirstItem();
    public Sequence buildLastItem();
    public Sequence buildMatchingItem(io.fabric8.kubernetes.api.builder.Predicate<SequenceBuilder> predicate);
    public Boolean hasMatchingItem(io.fabric8.kubernetes.api.builder.Predicate<SequenceBuilder> predicate);
    public A withItems(List<Sequence> items);
    public A withItems(Sequence... items);
    public Boolean hasItems();
    public SequenceListFluent.ItemsNested<A> addNewItem();
    public SequenceListFluent.ItemsNested<A> addNewItemLike(Sequence item);
    public SequenceListFluent.ItemsNested<A> setNewItemLike(int index,Sequence item);
    public SequenceListFluent.ItemsNested<A> editItem(int index);
    public SequenceListFluent.ItemsNested<A> editFirstItem();
    public SequenceListFluent.ItemsNested<A> editLastItem();
    public SequenceListFluent.ItemsNested<A> editMatchingItem(io.fabric8.kubernetes.api.builder.Predicate<SequenceBuilder> predicate);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    public ListMeta getMetadata();
    public A withMetadata(ListMeta metadata);
    public Boolean hasMetadata();
    public A withNewMetadata(String _continue,Long remainingItemCount,String resourceVersion,String selfLink);

    public interface ItemsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,SequenceFluent<SequenceListFluent.ItemsNested<N>>{

        
    public N and();    public N endItem();
}


}
