package io.fabric8.knative.serving.v1beta1;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.VolumeBuilder;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.model.VolumeFluentImpl;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ContainerFluentImpl;
import java.lang.StringBuffer;
import io.fabric8.kubernetes.api.model.Volume;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;

public class RevisionSpecFluentImpl<A extends RevisionSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements RevisionSpecFluent<A>{

    private Long containerConcurrency;
    private List<ContainerBuilder> containers;
    private String serviceAccountName;
    private Long timeoutSeconds;
    private List<VolumeBuilder> volumes;

    public RevisionSpecFluentImpl(){
    }
    public RevisionSpecFluentImpl(RevisionSpec instance){
            this.withContainerConcurrency(instance.getContainerConcurrency()); 
            this.withContainers(instance.getContainers()); 
            this.withServiceAccountName(instance.getServiceAccountName()); 
            this.withTimeoutSeconds(instance.getTimeoutSeconds()); 
            this.withVolumes(instance.getVolumes()); 
    }

    public Long getContainerConcurrency(){
            return this.containerConcurrency;
    }

    public A withContainerConcurrency(Long containerConcurrency){
            this.containerConcurrency=containerConcurrency; return (A) this;
    }

    public Boolean hasContainerConcurrency(){
            return this.containerConcurrency != null;
    }

    public A addToContainers(int index,Container item){
            if (this.containers == null) {this.containers = new ArrayList<ContainerBuilder>();}
            ContainerBuilder builder = new ContainerBuilder(item);_visitables.get("containers").add(index >= 0 ? index : _visitables.get("containers").size(), builder);this.containers.add(index >= 0 ? index : containers.size(), builder); return (A)this;
    }

    public A setToContainers(int index,Container item){
            if (this.containers == null) {this.containers = new ArrayList<ContainerBuilder>();}
            ContainerBuilder builder = new ContainerBuilder(item);
            if (index < 0 || index >= _visitables.get("containers").size()) { _visitables.get("containers").add(builder); } else { _visitables.get("containers").set(index, builder);}
            if (index < 0 || index >= containers.size()) { containers.add(builder); } else { containers.set(index, builder);}
             return (A)this;
    }

    public A addToContainers(Container... items){
            if (this.containers == null) {this.containers = new ArrayList<ContainerBuilder>();}
            for (Container item : items) {ContainerBuilder builder = new ContainerBuilder(item);_visitables.get("containers").add(builder);this.containers.add(builder);} return (A)this;
    }

    public A addAllToContainers(Collection<Container> items){
            if (this.containers == null) {this.containers = new ArrayList<ContainerBuilder>();}
            for (Container item : items) {ContainerBuilder builder = new ContainerBuilder(item);_visitables.get("containers").add(builder);this.containers.add(builder);} return (A)this;
    }

    public A removeFromContainers(Container... items){
            for (Container item : items) {ContainerBuilder builder = new ContainerBuilder(item);_visitables.get("containers").remove(builder);if (this.containers != null) {this.containers.remove(builder);}} return (A)this;
    }

    public A removeAllFromContainers(Collection<Container> items){
            for (Container item : items) {ContainerBuilder builder = new ContainerBuilder(item);_visitables.get("containers").remove(builder);if (this.containers != null) {this.containers.remove(builder);}} return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildContainers instead.
 * @return The buildable object.
 */
@Deprecated public List<Container> getContainers(){
            return build(containers);
    }

    public List<Container> buildContainers(){
            return build(containers);
    }

    public Container buildContainer(int index){
            return this.containers.get(index).build();
    }

    public Container buildFirstContainer(){
            return this.containers.get(0).build();
    }

    public Container buildLastContainer(){
            return this.containers.get(containers.size() - 1).build();
    }

    public Container buildMatchingContainer(io.fabric8.kubernetes.api.builder.Predicate<ContainerBuilder> predicate){
            for (ContainerBuilder item: containers) { if(predicate.apply(item)){return item.build();} } return null;
    }

    public Boolean hasMatchingContainer(io.fabric8.kubernetes.api.builder.Predicate<ContainerBuilder> predicate){
            for (ContainerBuilder item: containers) { if(predicate.apply(item)){return true;} } return false;
    }

    public A withContainers(List<Container> containers){
            if (this.containers != null) { _visitables.get("containers").removeAll(this.containers);}
            if (containers != null) {this.containers = new ArrayList<ContainerBuilder>(); for (Container item : containers){this.addToContainers(item);}} else { this.containers = new ArrayList<ContainerBuilder>();} return (A) this;
    }

    public A withContainers(Container... containers){
            if (this.containers != null) {this.containers.clear();}
            if (containers != null) {for (Container item :containers){ this.addToContainers(item);}} return (A) this;
    }

    public Boolean hasContainers(){
            return containers != null && !containers.isEmpty();
    }

    public RevisionSpecFluent.ContainersNested<A> addNewContainer(){
            return new ContainersNestedImpl();
    }

    public RevisionSpecFluent.ContainersNested<A> addNewContainerLike(Container item){
            return new ContainersNestedImpl(-1, item);
    }

    public RevisionSpecFluent.ContainersNested<A> setNewContainerLike(int index,Container item){
            return new ContainersNestedImpl(index, item);
    }

    public RevisionSpecFluent.ContainersNested<A> editContainer(int index){
            if (containers.size() <= index) throw new RuntimeException("Can't edit containers. Index exceeds size.");
            return setNewContainerLike(index, buildContainer(index));
    }

    public RevisionSpecFluent.ContainersNested<A> editFirstContainer(){
            if (containers.size() == 0) throw new RuntimeException("Can't edit first containers. The list is empty.");
            return setNewContainerLike(0, buildContainer(0));
    }

    public RevisionSpecFluent.ContainersNested<A> editLastContainer(){
            int index = containers.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last containers. The list is empty.");
            return setNewContainerLike(index, buildContainer(index));
    }

    public RevisionSpecFluent.ContainersNested<A> editMatchingContainer(io.fabric8.kubernetes.api.builder.Predicate<ContainerBuilder> predicate){
            int index = -1;
            for (int i=0;i<containers.size();i++) { 
            if (predicate.apply(containers.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching containers. No match found.");
            return setNewContainerLike(index, buildContainer(index));
    }

    public String getServiceAccountName(){
            return this.serviceAccountName;
    }

    public A withServiceAccountName(String serviceAccountName){
            this.serviceAccountName=serviceAccountName; return (A) this;
    }

    public Boolean hasServiceAccountName(){
            return this.serviceAccountName != null;
    }

    public A withNewServiceAccountName(String arg1){
            return (A)withServiceAccountName(new String(arg1));
    }

    public A withNewServiceAccountName(StringBuilder arg1){
            return (A)withServiceAccountName(new String(arg1));
    }

    public A withNewServiceAccountName(StringBuffer arg1){
            return (A)withServiceAccountName(new String(arg1));
    }

    public Long getTimeoutSeconds(){
            return this.timeoutSeconds;
    }

    public A withTimeoutSeconds(Long timeoutSeconds){
            this.timeoutSeconds=timeoutSeconds; return (A) this;
    }

    public Boolean hasTimeoutSeconds(){
            return this.timeoutSeconds != null;
    }

    public A addToVolumes(int index,Volume item){
            if (this.volumes == null) {this.volumes = new ArrayList<VolumeBuilder>();}
            VolumeBuilder builder = new VolumeBuilder(item);_visitables.get("volumes").add(index >= 0 ? index : _visitables.get("volumes").size(), builder);this.volumes.add(index >= 0 ? index : volumes.size(), builder); return (A)this;
    }

    public A setToVolumes(int index,Volume item){
            if (this.volumes == null) {this.volumes = new ArrayList<VolumeBuilder>();}
            VolumeBuilder builder = new VolumeBuilder(item);
            if (index < 0 || index >= _visitables.get("volumes").size()) { _visitables.get("volumes").add(builder); } else { _visitables.get("volumes").set(index, builder);}
            if (index < 0 || index >= volumes.size()) { volumes.add(builder); } else { volumes.set(index, builder);}
             return (A)this;
    }

    public A addToVolumes(Volume... items){
            if (this.volumes == null) {this.volumes = new ArrayList<VolumeBuilder>();}
            for (Volume item : items) {VolumeBuilder builder = new VolumeBuilder(item);_visitables.get("volumes").add(builder);this.volumes.add(builder);} return (A)this;
    }

    public A addAllToVolumes(Collection<Volume> items){
            if (this.volumes == null) {this.volumes = new ArrayList<VolumeBuilder>();}
            for (Volume item : items) {VolumeBuilder builder = new VolumeBuilder(item);_visitables.get("volumes").add(builder);this.volumes.add(builder);} return (A)this;
    }

    public A removeFromVolumes(Volume... items){
            for (Volume item : items) {VolumeBuilder builder = new VolumeBuilder(item);_visitables.get("volumes").remove(builder);if (this.volumes != null) {this.volumes.remove(builder);}} return (A)this;
    }

    public A removeAllFromVolumes(Collection<Volume> items){
            for (Volume item : items) {VolumeBuilder builder = new VolumeBuilder(item);_visitables.get("volumes").remove(builder);if (this.volumes != null) {this.volumes.remove(builder);}} return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildVolumes instead.
 * @return The buildable object.
 */
@Deprecated public List<Volume> getVolumes(){
            return build(volumes);
    }

    public List<Volume> buildVolumes(){
            return build(volumes);
    }

    public Volume buildVolume(int index){
            return this.volumes.get(index).build();
    }

    public Volume buildFirstVolume(){
            return this.volumes.get(0).build();
    }

    public Volume buildLastVolume(){
            return this.volumes.get(volumes.size() - 1).build();
    }

    public Volume buildMatchingVolume(io.fabric8.kubernetes.api.builder.Predicate<VolumeBuilder> predicate){
            for (VolumeBuilder item: volumes) { if(predicate.apply(item)){return item.build();} } return null;
    }

    public Boolean hasMatchingVolume(io.fabric8.kubernetes.api.builder.Predicate<VolumeBuilder> predicate){
            for (VolumeBuilder item: volumes) { if(predicate.apply(item)){return true;} } return false;
    }

    public A withVolumes(List<Volume> volumes){
            if (this.volumes != null) { _visitables.get("volumes").removeAll(this.volumes);}
            if (volumes != null) {this.volumes = new ArrayList<VolumeBuilder>(); for (Volume item : volumes){this.addToVolumes(item);}} else { this.volumes = new ArrayList<VolumeBuilder>();} return (A) this;
    }

    public A withVolumes(Volume... volumes){
            if (this.volumes != null) {this.volumes.clear();}
            if (volumes != null) {for (Volume item :volumes){ this.addToVolumes(item);}} return (A) this;
    }

    public Boolean hasVolumes(){
            return volumes != null && !volumes.isEmpty();
    }

    public RevisionSpecFluent.VolumesNested<A> addNewVolume(){
            return new VolumesNestedImpl();
    }

    public RevisionSpecFluent.VolumesNested<A> addNewVolumeLike(Volume item){
            return new VolumesNestedImpl(-1, item);
    }

    public RevisionSpecFluent.VolumesNested<A> setNewVolumeLike(int index,Volume item){
            return new VolumesNestedImpl(index, item);
    }

    public RevisionSpecFluent.VolumesNested<A> editVolume(int index){
            if (volumes.size() <= index) throw new RuntimeException("Can't edit volumes. Index exceeds size.");
            return setNewVolumeLike(index, buildVolume(index));
    }

    public RevisionSpecFluent.VolumesNested<A> editFirstVolume(){
            if (volumes.size() == 0) throw new RuntimeException("Can't edit first volumes. The list is empty.");
            return setNewVolumeLike(0, buildVolume(0));
    }

    public RevisionSpecFluent.VolumesNested<A> editLastVolume(){
            int index = volumes.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last volumes. The list is empty.");
            return setNewVolumeLike(index, buildVolume(index));
    }

    public RevisionSpecFluent.VolumesNested<A> editMatchingVolume(io.fabric8.kubernetes.api.builder.Predicate<VolumeBuilder> predicate){
            int index = -1;
            for (int i=0;i<volumes.size();i++) { 
            if (predicate.apply(volumes.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching volumes. No match found.");
            return setNewVolumeLike(index, buildVolume(index));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            RevisionSpecFluentImpl that = (RevisionSpecFluentImpl) o;
            if (containerConcurrency != null ? !containerConcurrency.equals(that.containerConcurrency) :that.containerConcurrency != null) return false;
            if (containers != null ? !containers.equals(that.containers) :that.containers != null) return false;
            if (serviceAccountName != null ? !serviceAccountName.equals(that.serviceAccountName) :that.serviceAccountName != null) return false;
            if (timeoutSeconds != null ? !timeoutSeconds.equals(that.timeoutSeconds) :that.timeoutSeconds != null) return false;
            if (volumes != null ? !volumes.equals(that.volumes) :that.volumes != null) return false;
            return true;
    }


    public class ContainersNestedImpl<N> extends ContainerFluentImpl<RevisionSpecFluent.ContainersNested<N>> implements RevisionSpecFluent.ContainersNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ContainerBuilder builder;
        private final int index;
    
            ContainersNestedImpl(int index,Container item){
                    this.index = index;
                    this.builder = new ContainerBuilder(this, item);
            }
            ContainersNestedImpl(){
                    this.index = -1;
                    this.builder = new ContainerBuilder(this);
            }
    
    public N and(){
            return (N) RevisionSpecFluentImpl.this.setToContainers(index, builder.build());
    }
    public N endContainer(){
            return and();
    }

}
    public class VolumesNestedImpl<N> extends VolumeFluentImpl<RevisionSpecFluent.VolumesNested<N>> implements RevisionSpecFluent.VolumesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final VolumeBuilder builder;
        private final int index;
    
            VolumesNestedImpl(int index,Volume item){
                    this.index = index;
                    this.builder = new VolumeBuilder(this, item);
            }
            VolumesNestedImpl(){
                    this.index = -1;
                    this.builder = new VolumeBuilder(this);
            }
    
    public N and(){
            return (N) RevisionSpecFluentImpl.this.setToVolumes(index, builder.build());
    }
    public N endVolume(){
            return and();
    }

}


}
