package io.fabric8.knative.serving.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class RevisionTemplateSpecBuilder extends RevisionTemplateSpecFluentImpl<RevisionTemplateSpecBuilder> implements VisitableBuilder<RevisionTemplateSpec,RevisionTemplateSpecBuilder>{

    RevisionTemplateSpecFluent<?> fluent;
    Boolean validationEnabled;

    public RevisionTemplateSpecBuilder(){
            this(true);
    }
    public RevisionTemplateSpecBuilder(Boolean validationEnabled){
            this(new RevisionTemplateSpec(), validationEnabled);
    }
    public RevisionTemplateSpecBuilder(RevisionTemplateSpecFluent<?> fluent){
            this(fluent, true);
    }
    public RevisionTemplateSpecBuilder(RevisionTemplateSpecFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new RevisionTemplateSpec(), validationEnabled);
    }
    public RevisionTemplateSpecBuilder(RevisionTemplateSpecFluent<?> fluent,RevisionTemplateSpec instance){
            this(fluent, instance, true);
    }
    public RevisionTemplateSpecBuilder(RevisionTemplateSpecFluent<?> fluent,RevisionTemplateSpec instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withMetadata(instance.getMetadata()); 
            fluent.withSpec(instance.getSpec()); 
            this.validationEnabled = validationEnabled; 
    }
    public RevisionTemplateSpecBuilder(RevisionTemplateSpec instance){
            this(instance,true);
    }
    public RevisionTemplateSpecBuilder(RevisionTemplateSpec instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withMetadata(instance.getMetadata()); 
            this.withSpec(instance.getSpec()); 
            this.validationEnabled = validationEnabled; 
    }

    public RevisionTemplateSpec build(){
            RevisionTemplateSpec buildable = new RevisionTemplateSpec(fluent.getMetadata(),fluent.getSpec());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            RevisionTemplateSpecBuilder that = (RevisionTemplateSpecBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
