package io.fabric8.knative.serving.v1beta1;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.knative.v1.URLFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.knative.v1.URL;
import io.fabric8.knative.v1.URLBuilder;
import java.lang.Integer;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

public interface TrafficTargetFluent<A extends TrafficTargetFluent<A>> extends Fluent<A>{


    public String getConfigurationName();
    public A withConfigurationName(String configurationName);
    public Boolean hasConfigurationName();
    public A withNewConfigurationName(String arg1);
    public A withNewConfigurationName(StringBuilder arg1);
    public A withNewConfigurationName(StringBuffer arg1);
    public Boolean isLatestRevision();
    public A withLatestRevision(Boolean latestRevision);
    public Boolean hasLatestRevision();
    public A withNewLatestRevision(String arg1);
    public A withNewLatestRevision(boolean arg1);
    public Integer getPercent();
    public A withPercent(Integer percent);
    public Boolean hasPercent();
    public String getRevisionName();
    public A withRevisionName(String revisionName);
    public Boolean hasRevisionName();
    public A withNewRevisionName(String arg1);
    public A withNewRevisionName(StringBuilder arg1);
    public A withNewRevisionName(StringBuffer arg1);
    public String getTag();
    public A withTag(String tag);
    public Boolean hasTag();
    public A withNewTag(String arg1);
    public A withNewTag(StringBuilder arg1);
    public A withNewTag(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildUrl instead.
 * @return The buildable object.
 */
@Deprecated public URL getUrl();
    public URL buildUrl();
    public A withUrl(URL url);
    public Boolean hasUrl();
    public TrafficTargetFluent.UrlNested<A> withNewUrl();
    public TrafficTargetFluent.UrlNested<A> withNewUrlLike(URL item);
    public TrafficTargetFluent.UrlNested<A> editUrl();
    public TrafficTargetFluent.UrlNested<A> editOrNewUrl();
    public TrafficTargetFluent.UrlNested<A> editOrNewUrlLike(URL item);

    public interface UrlNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,URLFluent<TrafficTargetFluent.UrlNested<N>>{

        
    public N and();    public N endUrl();
}


}
