package io.fabric8.knative.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class KnativeSchemaBuilder extends KnativeSchemaFluentImpl<KnativeSchemaBuilder> implements VisitableBuilder<KnativeSchema,KnativeSchemaBuilder>{

    KnativeSchemaFluent<?> fluent;
    Boolean validationEnabled;

    public KnativeSchemaBuilder(){
            this(true);
    }
    public KnativeSchemaBuilder(Boolean validationEnabled){
            this(new KnativeSchema(), validationEnabled);
    }
    public KnativeSchemaBuilder(KnativeSchemaFluent<?> fluent){
            this(fluent, true);
    }
    public KnativeSchemaBuilder(KnativeSchemaFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new KnativeSchema(), validationEnabled);
    }
    public KnativeSchemaBuilder(KnativeSchemaFluent<?> fluent,KnativeSchema instance){
            this(fluent, instance, true);
    }
    public KnativeSchemaBuilder(KnativeSchemaFluent<?> fluent,KnativeSchema instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withBroker(instance.getBroker()); 
            fluent.withBrokerList(instance.getBrokerList()); 
            fluent.withChannel(instance.getChannel()); 
            fluent.withChannelList(instance.getChannelList()); 
            fluent.withClusterChannelProvisioner(instance.getClusterChannelProvisioner()); 
            fluent.withClusterChannelProvisionerList(instance.getClusterChannelProvisionerList()); 
            fluent.withConfiguration(instance.getConfiguration()); 
            fluent.withConfigurationList(instance.getConfigurationList()); 
            fluent.withEventType(instance.getEventType()); 
            fluent.withEventTypeList(instance.getEventTypeList()); 
            fluent.withInMemoryChannel(instance.getInMemoryChannel()); 
            fluent.withInMemoryChannelList(instance.getInMemoryChannelList()); 
            fluent.withRevision(instance.getRevision()); 
            fluent.withRevisionList(instance.getRevisionList()); 
            fluent.withRoute(instance.getRoute()); 
            fluent.withRouteList(instance.getRouteList()); 
            fluent.withSequence(instance.getSequence()); 
            fluent.withSequenceList(instance.getSequenceList()); 
            fluent.withService(instance.getService()); 
            fluent.withServiceList(instance.getServiceList()); 
            fluent.withSubscription(instance.getSubscription()); 
            fluent.withSubscriptionList(instance.getSubscriptionList()); 
            fluent.withTrigger(instance.getTrigger()); 
            fluent.withTriggerList(instance.getTriggerList()); 
            this.validationEnabled = validationEnabled; 
    }
    public KnativeSchemaBuilder(KnativeSchema instance){
            this(instance,true);
    }
    public KnativeSchemaBuilder(KnativeSchema instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withBroker(instance.getBroker()); 
            this.withBrokerList(instance.getBrokerList()); 
            this.withChannel(instance.getChannel()); 
            this.withChannelList(instance.getChannelList()); 
            this.withClusterChannelProvisioner(instance.getClusterChannelProvisioner()); 
            this.withClusterChannelProvisionerList(instance.getClusterChannelProvisionerList()); 
            this.withConfiguration(instance.getConfiguration()); 
            this.withConfigurationList(instance.getConfigurationList()); 
            this.withEventType(instance.getEventType()); 
            this.withEventTypeList(instance.getEventTypeList()); 
            this.withInMemoryChannel(instance.getInMemoryChannel()); 
            this.withInMemoryChannelList(instance.getInMemoryChannelList()); 
            this.withRevision(instance.getRevision()); 
            this.withRevisionList(instance.getRevisionList()); 
            this.withRoute(instance.getRoute()); 
            this.withRouteList(instance.getRouteList()); 
            this.withSequence(instance.getSequence()); 
            this.withSequenceList(instance.getSequenceList()); 
            this.withService(instance.getService()); 
            this.withServiceList(instance.getServiceList()); 
            this.withSubscription(instance.getSubscription()); 
            this.withSubscriptionList(instance.getSubscriptionList()); 
            this.withTrigger(instance.getTrigger()); 
            this.withTriggerList(instance.getTriggerList()); 
            this.validationEnabled = validationEnabled; 
    }

    public KnativeSchema build(){
            KnativeSchema buildable = new KnativeSchema(fluent.getBroker(),fluent.getBrokerList(),fluent.getChannel(),fluent.getChannelList(),fluent.getClusterChannelProvisioner(),fluent.getClusterChannelProvisionerList(),fluent.getConfiguration(),fluent.getConfigurationList(),fluent.getEventType(),fluent.getEventTypeList(),fluent.getInMemoryChannel(),fluent.getInMemoryChannelList(),fluent.getRevision(),fluent.getRevisionList(),fluent.getRoute(),fluent.getRouteList(),fluent.getSequence(),fluent.getSequenceList(),fluent.getService(),fluent.getServiceList(),fluent.getSubscription(),fluent.getSubscriptionList(),fluent.getTrigger(),fluent.getTriggerList());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            KnativeSchemaBuilder that = (KnativeSchemaBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
