package io.fabric8.knative.duck.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class SubscribableBuilder extends SubscribableFluentImpl<SubscribableBuilder> implements VisitableBuilder<Subscribable,SubscribableBuilder>{

    SubscribableFluent<?> fluent;
    Boolean validationEnabled;

    public SubscribableBuilder(){
            this(true);
    }
    public SubscribableBuilder(Boolean validationEnabled){
            this(new Subscribable(), validationEnabled);
    }
    public SubscribableBuilder(SubscribableFluent<?> fluent){
            this(fluent, true);
    }
    public SubscribableBuilder(SubscribableFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new Subscribable(), validationEnabled);
    }
    public SubscribableBuilder(SubscribableFluent<?> fluent,Subscribable instance){
            this(fluent, instance, true);
    }
    public SubscribableBuilder(SubscribableFluent<?> fluent,Subscribable instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withSubscribers(instance.getSubscribers()); 
            this.validationEnabled = validationEnabled; 
    }
    public SubscribableBuilder(Subscribable instance){
            this(instance,true);
    }
    public SubscribableBuilder(Subscribable instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withSubscribers(instance.getSubscribers()); 
            this.validationEnabled = validationEnabled; 
    }

    public Subscribable build(){
            Subscribable buildable = new Subscribable(fluent.getSubscribers());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            SubscribableBuilder that = (SubscribableBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
