package io.fabric8.knative.eventing.v1alpha1;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.knative.duck.v1alpha1.SubscribableFluent;
import io.fabric8.knative.duck.v1alpha1.Subscribable;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.knative.duck.v1alpha1.SubscribableBuilder;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.model.ObjectReference;
import java.lang.Deprecated;
import java.lang.Long;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

public interface ChannelSpecFluent<A extends ChannelSpecFluent<A>> extends Fluent<A>{


    public A addToArguments(String key,Object value);
    public A addToArguments(Map<String,Object> map);
    public A removeFromArguments(String key);
    public A removeFromArguments(Map<String,Object> map);
    public Map<String,Object> getArguments();
    public A withArguments(Map<String,Object> arguments);
    public Boolean hasArguments();
    public Long getGeneration();
    public A withGeneration(Long generation);
    public Boolean hasGeneration();
    public ObjectReference getProvisioner();
    public A withProvisioner(ObjectReference provisioner);
    public Boolean hasProvisioner();
    
/**
 * This method has been deprecated, please use method buildSubscribable instead.
 * @return The buildable object.
 */
@Deprecated public Subscribable getSubscribable();
    public Subscribable buildSubscribable();
    public A withSubscribable(Subscribable subscribable);
    public Boolean hasSubscribable();
    public ChannelSpecFluent.SubscribableNested<A> withNewSubscribable();
    public ChannelSpecFluent.SubscribableNested<A> withNewSubscribableLike(Subscribable item);
    public ChannelSpecFluent.SubscribableNested<A> editSubscribable();
    public ChannelSpecFluent.SubscribableNested<A> editOrNewSubscribable();
    public ChannelSpecFluent.SubscribableNested<A> editOrNewSubscribableLike(Subscribable item);

    public interface SubscribableNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,SubscribableFluent<ChannelSpecFluent.SubscribableNested<N>>{

        
    public N and();    public N endSubscribable();
}


}
