package io.fabric8.knative.eventing.v1alpha1;

import java.lang.StringBuffer;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class EventTypeSpecFluentImpl<A extends EventTypeSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements EventTypeSpecFluent<A>{

    private String broker;
    private String description;
    private String schema;
    private String source;
    private String type;

    public EventTypeSpecFluentImpl(){
    }
    public EventTypeSpecFluentImpl(EventTypeSpec instance){
            this.withBroker(instance.getBroker()); 
            this.withDescription(instance.getDescription()); 
            this.withSchema(instance.getSchema()); 
            this.withSource(instance.getSource()); 
            this.withType(instance.getType()); 
    }

    public String getBroker(){
            return this.broker;
    }

    public A withBroker(String broker){
            this.broker=broker; return (A) this;
    }

    public Boolean hasBroker(){
            return this.broker != null;
    }

    public A withNewBroker(String arg1){
            return (A)withBroker(new String(arg1));
    }

    public A withNewBroker(StringBuilder arg1){
            return (A)withBroker(new String(arg1));
    }

    public A withNewBroker(StringBuffer arg1){
            return (A)withBroker(new String(arg1));
    }

    public String getDescription(){
            return this.description;
    }

    public A withDescription(String description){
            this.description=description; return (A) this;
    }

    public Boolean hasDescription(){
            return this.description != null;
    }

    public A withNewDescription(String arg1){
            return (A)withDescription(new String(arg1));
    }

    public A withNewDescription(StringBuilder arg1){
            return (A)withDescription(new String(arg1));
    }

    public A withNewDescription(StringBuffer arg1){
            return (A)withDescription(new String(arg1));
    }

    public String getSchema(){
            return this.schema;
    }

    public A withSchema(String schema){
            this.schema=schema; return (A) this;
    }

    public Boolean hasSchema(){
            return this.schema != null;
    }

    public A withNewSchema(String arg1){
            return (A)withSchema(new String(arg1));
    }

    public A withNewSchema(StringBuilder arg1){
            return (A)withSchema(new String(arg1));
    }

    public A withNewSchema(StringBuffer arg1){
            return (A)withSchema(new String(arg1));
    }

    public String getSource(){
            return this.source;
    }

    public A withSource(String source){
            this.source=source; return (A) this;
    }

    public Boolean hasSource(){
            return this.source != null;
    }

    public A withNewSource(String arg1){
            return (A)withSource(new String(arg1));
    }

    public A withNewSource(StringBuilder arg1){
            return (A)withSource(new String(arg1));
    }

    public A withNewSource(StringBuffer arg1){
            return (A)withSource(new String(arg1));
    }

    public String getType(){
            return this.type;
    }

    public A withType(String type){
            this.type=type; return (A) this;
    }

    public Boolean hasType(){
            return this.type != null;
    }

    public A withNewType(String arg1){
            return (A)withType(new String(arg1));
    }

    public A withNewType(StringBuilder arg1){
            return (A)withType(new String(arg1));
    }

    public A withNewType(StringBuffer arg1){
            return (A)withType(new String(arg1));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            EventTypeSpecFluentImpl that = (EventTypeSpecFluentImpl) o;
            if (broker != null ? !broker.equals(that.broker) :that.broker != null) return false;
            if (description != null ? !description.equals(that.description) :that.description != null) return false;
            if (schema != null ? !schema.equals(that.schema) :that.schema != null) return false;
            if (source != null ? !source.equals(that.source) :that.source != null) return false;
            if (type != null ? !type.equals(that.type) :that.type != null) return false;
            return true;
    }




}
