package io.fabric8.knative.serving.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ConfigurationBuilder extends ConfigurationFluentImpl<ConfigurationBuilder> implements VisitableBuilder<Configuration,ConfigurationBuilder>{

    ConfigurationFluent<?> fluent;
    Boolean validationEnabled;

    public ConfigurationBuilder(){
            this(true);
    }
    public ConfigurationBuilder(Boolean validationEnabled){
            this(new Configuration(), validationEnabled);
    }
    public ConfigurationBuilder(ConfigurationFluent<?> fluent){
            this(fluent, true);
    }
    public ConfigurationBuilder(ConfigurationFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new Configuration(), validationEnabled);
    }
    public ConfigurationBuilder(ConfigurationFluent<?> fluent,Configuration instance){
            this(fluent, instance, true);
    }
    public ConfigurationBuilder(ConfigurationFluent<?> fluent,Configuration instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            fluent.withSpec(instance.getSpec()); 
            fluent.withStatus(instance.getStatus()); 
            this.validationEnabled = validationEnabled; 
    }
    public ConfigurationBuilder(Configuration instance){
            this(instance,true);
    }
    public ConfigurationBuilder(Configuration instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.withSpec(instance.getSpec()); 
            this.withStatus(instance.getStatus()); 
            this.validationEnabled = validationEnabled; 
    }

    public Configuration build(){
            Configuration buildable = new Configuration(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ConfigurationBuilder that = (ConfigurationBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
