package io.fabric8.knative.eventing.v1alpha1;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.knative.duck.v1alpha1.Subscribable;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.knative.duck.v1alpha1.SubscribableBuilder;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.model.ObjectReference;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Long;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;
import io.fabric8.knative.duck.v1alpha1.SubscribableFluentImpl;

public class ChannelSpecFluentImpl<A extends ChannelSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements ChannelSpecFluent<A>{

    private Map<String,Object> arguments;
    private Long generation;
    private ObjectReference provisioner;
    private SubscribableBuilder subscribable;

    public ChannelSpecFluentImpl(){
    }
    public ChannelSpecFluentImpl(ChannelSpec instance){
            this.withArguments(instance.getArguments()); 
            this.withGeneration(instance.getGeneration()); 
            this.withProvisioner(instance.getProvisioner()); 
            this.withSubscribable(instance.getSubscribable()); 
    }

    public A addToArguments(String key,Object value){
            if(this.arguments == null && key != null && value != null) { this.arguments = new LinkedHashMap<String,Object>(); }
            if(key != null && value != null) {this.arguments.put(key, value);} return (A)this;
    }

    public A addToArguments(Map<String,Object> map){
            if(this.arguments == null && map != null) { this.arguments = new LinkedHashMap<String,Object>(); }
            if(map != null) { this.arguments.putAll(map);} return (A)this;
    }

    public A removeFromArguments(String key){
            if(this.arguments == null) { return (A) this; }
            if(key != null && this.arguments != null) {this.arguments.remove(key);} return (A)this;
    }

    public A removeFromArguments(Map<String,Object> map){
            if(this.arguments == null) { return (A) this; }
            if(map != null) { for(Object key : map.keySet()) {if (this.arguments != null){this.arguments.remove(key);}}} return (A)this;
    }

    public Map<String,Object> getArguments(){
            return this.arguments;
    }

    public A withArguments(Map<String,Object> arguments){
            if (arguments == null) { this.arguments =  new LinkedHashMap<String,Object>();} else {this.arguments = new LinkedHashMap<String,Object>(arguments);} return (A) this;
    }

    public Boolean hasArguments(){
            return this.arguments != null;
    }

    public Long getGeneration(){
            return this.generation;
    }

    public A withGeneration(Long generation){
            this.generation=generation; return (A) this;
    }

    public Boolean hasGeneration(){
            return this.generation != null;
    }

    public ObjectReference getProvisioner(){
            return this.provisioner;
    }

    public A withProvisioner(ObjectReference provisioner){
            this.provisioner=provisioner; return (A) this;
    }

    public Boolean hasProvisioner(){
            return this.provisioner != null;
    }

    
/**
 * This method has been deprecated, please use method buildSubscribable instead.
 * @return The buildable object.
 */
@Deprecated public Subscribable getSubscribable(){
            return this.subscribable!=null?this.subscribable.build():null;
    }

    public Subscribable buildSubscribable(){
            return this.subscribable!=null?this.subscribable.build():null;
    }

    public A withSubscribable(Subscribable subscribable){
            _visitables.get("subscribable").remove(this.subscribable);
            if (subscribable!=null){ this.subscribable= new SubscribableBuilder(subscribable); _visitables.get("subscribable").add(this.subscribable);} return (A) this;
    }

    public Boolean hasSubscribable(){
            return this.subscribable != null;
    }

    public ChannelSpecFluent.SubscribableNested<A> withNewSubscribable(){
            return new SubscribableNestedImpl();
    }

    public ChannelSpecFluent.SubscribableNested<A> withNewSubscribableLike(Subscribable item){
            return new SubscribableNestedImpl(item);
    }

    public ChannelSpecFluent.SubscribableNested<A> editSubscribable(){
            return withNewSubscribableLike(getSubscribable());
    }

    public ChannelSpecFluent.SubscribableNested<A> editOrNewSubscribable(){
            return withNewSubscribableLike(getSubscribable() != null ? getSubscribable(): new SubscribableBuilder().build());
    }

    public ChannelSpecFluent.SubscribableNested<A> editOrNewSubscribableLike(Subscribable item){
            return withNewSubscribableLike(getSubscribable() != null ? getSubscribable(): item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ChannelSpecFluentImpl that = (ChannelSpecFluentImpl) o;
            if (arguments != null ? !arguments.equals(that.arguments) :that.arguments != null) return false;
            if (generation != null ? !generation.equals(that.generation) :that.generation != null) return false;
            if (provisioner != null ? !provisioner.equals(that.provisioner) :that.provisioner != null) return false;
            if (subscribable != null ? !subscribable.equals(that.subscribable) :that.subscribable != null) return false;
            return true;
    }


    public class SubscribableNestedImpl<N> extends SubscribableFluentImpl<ChannelSpecFluent.SubscribableNested<N>> implements ChannelSpecFluent.SubscribableNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final SubscribableBuilder builder;
    
            SubscribableNestedImpl(Subscribable item){
                    this.builder = new SubscribableBuilder(this, item);
            }
            SubscribableNestedImpl(){
                    this.builder = new SubscribableBuilder(this);
            }
    
    public N and(){
            return (N) ChannelSpecFluentImpl.this.withSubscribable(builder.build());
    }
    public N endSubscribable(){
            return and();
    }

}


}
