package io.fabric8.knative.serving.v1;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class RouteSpecFluentImpl<A extends RouteSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements RouteSpecFluent<A>{

    private List<TrafficTargetBuilder> traffic;

    public RouteSpecFluentImpl(){
    }
    public RouteSpecFluentImpl(RouteSpec instance){
            this.withTraffic(instance.getTraffic()); 
    }

    public A addToTraffic(int index,TrafficTarget item){
            if (this.traffic == null) {this.traffic = new ArrayList<TrafficTargetBuilder>();}
            TrafficTargetBuilder builder = new TrafficTargetBuilder(item);_visitables.get("traffic").add(index >= 0 ? index : _visitables.get("traffic").size(), builder);this.traffic.add(index >= 0 ? index : traffic.size(), builder); return (A)this;
    }

    public A setToTraffic(int index,TrafficTarget item){
            if (this.traffic == null) {this.traffic = new ArrayList<TrafficTargetBuilder>();}
            TrafficTargetBuilder builder = new TrafficTargetBuilder(item);
            if (index < 0 || index >= _visitables.get("traffic").size()) { _visitables.get("traffic").add(builder); } else { _visitables.get("traffic").set(index, builder);}
            if (index < 0 || index >= traffic.size()) { traffic.add(builder); } else { traffic.set(index, builder);}
             return (A)this;
    }

    public A addToTraffic(TrafficTarget... items){
            if (this.traffic == null) {this.traffic = new ArrayList<TrafficTargetBuilder>();}
            for (TrafficTarget item : items) {TrafficTargetBuilder builder = new TrafficTargetBuilder(item);_visitables.get("traffic").add(builder);this.traffic.add(builder);} return (A)this;
    }

    public A addAllToTraffic(Collection<TrafficTarget> items){
            if (this.traffic == null) {this.traffic = new ArrayList<TrafficTargetBuilder>();}
            for (TrafficTarget item : items) {TrafficTargetBuilder builder = new TrafficTargetBuilder(item);_visitables.get("traffic").add(builder);this.traffic.add(builder);} return (A)this;
    }

    public A removeFromTraffic(TrafficTarget... items){
            for (TrafficTarget item : items) {TrafficTargetBuilder builder = new TrafficTargetBuilder(item);_visitables.get("traffic").remove(builder);if (this.traffic != null) {this.traffic.remove(builder);}} return (A)this;
    }

    public A removeAllFromTraffic(Collection<TrafficTarget> items){
            for (TrafficTarget item : items) {TrafficTargetBuilder builder = new TrafficTargetBuilder(item);_visitables.get("traffic").remove(builder);if (this.traffic != null) {this.traffic.remove(builder);}} return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildTraffic instead.
 * @return The buildable object.
 */
@Deprecated public List<TrafficTarget> getTraffic(){
            return build(traffic);
    }

    public List<TrafficTarget> buildTraffic(){
            return build(traffic);
    }

    public TrafficTarget buildTraffic(int index){
            return this.traffic.get(index).build();
    }

    public TrafficTarget buildFirstTraffic(){
            return this.traffic.get(0).build();
    }

    public TrafficTarget buildLastTraffic(){
            return this.traffic.get(traffic.size() - 1).build();
    }

    public TrafficTarget buildMatchingTraffic(io.fabric8.kubernetes.api.builder.Predicate<TrafficTargetBuilder> predicate){
            for (TrafficTargetBuilder item: traffic) { if(predicate.apply(item)){return item.build();} } return null;
    }

    public Boolean hasMatchingTraffic(io.fabric8.kubernetes.api.builder.Predicate<TrafficTargetBuilder> predicate){
            for (TrafficTargetBuilder item: traffic) { if(predicate.apply(item)){return true;} } return false;
    }

    public A withTraffic(List<TrafficTarget> traffic){
            if (this.traffic != null) { _visitables.get("traffic").removeAll(this.traffic);}
            if (traffic != null) {this.traffic = new ArrayList<TrafficTargetBuilder>(); for (TrafficTarget item : traffic){this.addToTraffic(item);}} else { this.traffic = new ArrayList<TrafficTargetBuilder>();} return (A) this;
    }

    public A withTraffic(TrafficTarget... traffic){
            if (this.traffic != null) {this.traffic.clear();}
            if (traffic != null) {for (TrafficTarget item :traffic){ this.addToTraffic(item);}} return (A) this;
    }

    public Boolean hasTraffic(){
            return traffic != null && !traffic.isEmpty();
    }

    public RouteSpecFluent.TrafficNested<A> addNewTraffic(){
            return new TrafficNestedImpl();
    }

    public RouteSpecFluent.TrafficNested<A> addNewTrafficLike(TrafficTarget item){
            return new TrafficNestedImpl(-1, item);
    }

    public RouteSpecFluent.TrafficNested<A> setNewTrafficLike(int index,TrafficTarget item){
            return new TrafficNestedImpl(index, item);
    }

    public RouteSpecFluent.TrafficNested<A> editTraffic(int index){
            if (traffic.size() <= index) throw new RuntimeException("Can't edit traffic. Index exceeds size.");
            return setNewTrafficLike(index, buildTraffic(index));
    }

    public RouteSpecFluent.TrafficNested<A> editFirstTraffic(){
            if (traffic.size() == 0) throw new RuntimeException("Can't edit first traffic. The list is empty.");
            return setNewTrafficLike(0, buildTraffic(0));
    }

    public RouteSpecFluent.TrafficNested<A> editLastTraffic(){
            int index = traffic.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last traffic. The list is empty.");
            return setNewTrafficLike(index, buildTraffic(index));
    }

    public RouteSpecFluent.TrafficNested<A> editMatchingTraffic(io.fabric8.kubernetes.api.builder.Predicate<TrafficTargetBuilder> predicate){
            int index = -1;
            for (int i=0;i<traffic.size();i++) { 
            if (predicate.apply(traffic.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching traffic. No match found.");
            return setNewTrafficLike(index, buildTraffic(index));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            RouteSpecFluentImpl that = (RouteSpecFluentImpl) o;
            if (traffic != null ? !traffic.equals(that.traffic) :that.traffic != null) return false;
            return true;
    }


    public class TrafficNestedImpl<N> extends TrafficTargetFluentImpl<RouteSpecFluent.TrafficNested<N>> implements RouteSpecFluent.TrafficNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final TrafficTargetBuilder builder;
        private final int index;
    
            TrafficNestedImpl(int index,TrafficTarget item){
                    this.index = index;
                    this.builder = new TrafficTargetBuilder(this, item);
            }
            TrafficNestedImpl(){
                    this.index = -1;
                    this.builder = new TrafficTargetBuilder(this);
            }
    
    public N and(){
            return (N) RouteSpecFluentImpl.this.setToTraffic(index, builder.build());
    }
    public N endTraffic(){
            return and();
    }

}


}
