package io.fabric8.knative.serving.v1alpha1;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Long;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

public class ConfigurationSpecFluentImpl<A extends io.fabric8.knative.serving.v1alpha1.ConfigurationSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.knative.serving.v1alpha1.ConfigurationSpecFluent<A>{

    private Map<String,Object> build;
    private Long generation;
    private io.fabric8.knative.serving.v1alpha1.RevisionTemplateSpecBuilder revisionTemplate;
    private io.fabric8.knative.serving.v1alpha1.RevisionTemplateSpecBuilder template;

    public ConfigurationSpecFluentImpl(){
    }
    public ConfigurationSpecFluentImpl(io.fabric8.knative.serving.v1alpha1.ConfigurationSpec instance){
            this.withBuild(instance.getBuild()); 
            this.withGeneration(instance.getGeneration()); 
            this.withRevisionTemplate(instance.getRevisionTemplate()); 
            this.withTemplate(instance.getTemplate()); 
    }

    public A addToBuild(String key,Object value){
            if(this.build == null && key != null && value != null) { this.build = new LinkedHashMap<String,Object>(); }
            if(key != null && value != null) {this.build.put(key, value);} return (A)this;
    }

    public A addToBuild(Map<String,Object> map){
            if(this.build == null && map != null) { this.build = new LinkedHashMap<String,Object>(); }
            if(map != null) { this.build.putAll(map);} return (A)this;
    }

    public A removeFromBuild(String key){
            if(this.build == null) { return (A) this; }
            if(key != null && this.build != null) {this.build.remove(key);} return (A)this;
    }

    public A removeFromBuild(Map<String,Object> map){
            if(this.build == null) { return (A) this; }
            if(map != null) { for(Object key : map.keySet()) {if (this.build != null){this.build.remove(key);}}} return (A)this;
    }

    public Map<String,Object> getBuild(){
            return this.build;
    }

    public A withBuild(Map<String,Object> build){
            if (build == null) { this.build =  new LinkedHashMap<String,Object>();} else {this.build = new LinkedHashMap<String,Object>(build);} return (A) this;
    }

    public Boolean hasBuild(){
            return this.build != null;
    }

    public Long getGeneration(){
            return this.generation;
    }

    public A withGeneration(Long generation){
            this.generation=generation; return (A) this;
    }

    public Boolean hasGeneration(){
            return this.generation != null;
    }

    
/**
 * This method has been deprecated, please use method buildRevisionTemplate instead.
 * @return The buildable object.
 */
@Deprecated public io.fabric8.knative.serving.v1alpha1.RevisionTemplateSpec getRevisionTemplate(){
            return this.revisionTemplate!=null?this.revisionTemplate.build():null;
    }

    public io.fabric8.knative.serving.v1alpha1.RevisionTemplateSpec buildRevisionTemplate(){
            return this.revisionTemplate!=null?this.revisionTemplate.build():null;
    }

    public A withRevisionTemplate(io.fabric8.knative.serving.v1alpha1.RevisionTemplateSpec revisionTemplate){
            _visitables.get("revisionTemplate").remove(this.revisionTemplate);
            if (revisionTemplate!=null){ this.revisionTemplate= new io.fabric8.knative.serving.v1alpha1.RevisionTemplateSpecBuilder(revisionTemplate); _visitables.get("revisionTemplate").add(this.revisionTemplate);} return (A) this;
    }

    public Boolean hasRevisionTemplate(){
            return this.revisionTemplate != null;
    }

    public ConfigurationSpecFluent.RevisionTemplateNested<A> withNewRevisionTemplate(){
            return new RevisionTemplateNestedImpl();
    }

    public ConfigurationSpecFluent.RevisionTemplateNested<A> withNewRevisionTemplateLike(io.fabric8.knative.serving.v1alpha1.RevisionTemplateSpec item){
            return new RevisionTemplateNestedImpl(item);
    }

    public ConfigurationSpecFluent.RevisionTemplateNested<A> editRevisionTemplate(){
            return withNewRevisionTemplateLike(getRevisionTemplate());
    }

    public ConfigurationSpecFluent.RevisionTemplateNested<A> editOrNewRevisionTemplate(){
            return withNewRevisionTemplateLike(getRevisionTemplate() != null ? getRevisionTemplate(): new io.fabric8.knative.serving.v1alpha1.RevisionTemplateSpecBuilder().build());
    }

    public ConfigurationSpecFluent.RevisionTemplateNested<A> editOrNewRevisionTemplateLike(io.fabric8.knative.serving.v1alpha1.RevisionTemplateSpec item){
            return withNewRevisionTemplateLike(getRevisionTemplate() != null ? getRevisionTemplate(): item);
    }

    
/**
 * This method has been deprecated, please use method buildTemplate instead.
 * @return The buildable object.
 */
@Deprecated public io.fabric8.knative.serving.v1alpha1.RevisionTemplateSpec getTemplate(){
            return this.template!=null?this.template.build():null;
    }

    public io.fabric8.knative.serving.v1alpha1.RevisionTemplateSpec buildTemplate(){
            return this.template!=null?this.template.build():null;
    }

    public A withTemplate(io.fabric8.knative.serving.v1alpha1.RevisionTemplateSpec template){
            _visitables.get("template").remove(this.template);
            if (template!=null){ this.template= new io.fabric8.knative.serving.v1alpha1.RevisionTemplateSpecBuilder(template); _visitables.get("template").add(this.template);} return (A) this;
    }

    public Boolean hasTemplate(){
            return this.template != null;
    }

    public ConfigurationSpecFluent.TemplateNested<A> withNewTemplate(){
            return new TemplateNestedImpl();
    }

    public ConfigurationSpecFluent.TemplateNested<A> withNewTemplateLike(io.fabric8.knative.serving.v1alpha1.RevisionTemplateSpec item){
            return new TemplateNestedImpl(item);
    }

    public ConfigurationSpecFluent.TemplateNested<A> editTemplate(){
            return withNewTemplateLike(getTemplate());
    }

    public ConfigurationSpecFluent.TemplateNested<A> editOrNewTemplate(){
            return withNewTemplateLike(getTemplate() != null ? getTemplate(): new io.fabric8.knative.serving.v1alpha1.RevisionTemplateSpecBuilder().build());
    }

    public ConfigurationSpecFluent.TemplateNested<A> editOrNewTemplateLike(io.fabric8.knative.serving.v1alpha1.RevisionTemplateSpec item){
            return withNewTemplateLike(getTemplate() != null ? getTemplate(): item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ConfigurationSpecFluentImpl that = (ConfigurationSpecFluentImpl) o;
            if (build != null ? !build.equals(that.build) :that.build != null) return false;
            if (generation != null ? !generation.equals(that.generation) :that.generation != null) return false;
            if (revisionTemplate != null ? !revisionTemplate.equals(that.revisionTemplate) :that.revisionTemplate != null) return false;
            if (template != null ? !template.equals(that.template) :that.template != null) return false;
            return true;
    }


    public class RevisionTemplateNestedImpl<N> extends io.fabric8.knative.serving.v1alpha1.RevisionTemplateSpecFluentImpl<ConfigurationSpecFluent.RevisionTemplateNested<N>> implements ConfigurationSpecFluent.RevisionTemplateNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final io.fabric8.knative.serving.v1alpha1.RevisionTemplateSpecBuilder builder;
    
            RevisionTemplateNestedImpl(io.fabric8.knative.serving.v1alpha1.RevisionTemplateSpec item){
                    this.builder = new io.fabric8.knative.serving.v1alpha1.RevisionTemplateSpecBuilder(this, item);
            }
            RevisionTemplateNestedImpl(){
                    this.builder = new io.fabric8.knative.serving.v1alpha1.RevisionTemplateSpecBuilder(this);
            }
    
    public N and(){
            return (N) ConfigurationSpecFluentImpl.this.withRevisionTemplate(builder.build());
    }
    public N endRevisionTemplate(){
            return and();
    }

}
    public class TemplateNestedImpl<N> extends io.fabric8.knative.serving.v1alpha1.RevisionTemplateSpecFluentImpl<ConfigurationSpecFluent.TemplateNested<N>> implements ConfigurationSpecFluent.TemplateNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final io.fabric8.knative.serving.v1alpha1.RevisionTemplateSpecBuilder builder;
    
            TemplateNestedImpl(io.fabric8.knative.serving.v1alpha1.RevisionTemplateSpec item){
                    this.builder = new io.fabric8.knative.serving.v1alpha1.RevisionTemplateSpecBuilder(this, item);
            }
            TemplateNestedImpl(){
                    this.builder = new io.fabric8.knative.serving.v1alpha1.RevisionTemplateSpecBuilder(this);
            }
    
    public N and(){
            return (N) ConfigurationSpecFluentImpl.this.withTemplate(builder.build());
    }
    public N endTemplate(){
            return and();
    }

}


}
