package io.fabric8.knative.serving.v1beta1;

import io.fabric8.knative.serving.v1.ServiceStatusBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.knative.serving.v1.ServiceSpec;
import io.fabric8.knative.serving.v1.ServiceSpecFluentImpl;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.Deprecated;
import io.fabric8.knative.serving.v1.ServiceStatus;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.knative.serving.v1.ServiceSpecBuilder;
import java.lang.StringBuffer;
import java.lang.Object;
import io.fabric8.knative.serving.v1.ServiceStatusFluentImpl;

public class ServiceFluentImpl<A extends io.fabric8.knative.serving.v1beta1.ServiceFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.knative.serving.v1beta1.ServiceFluent<A>{

    private String apiVersion;
    private String kind;
    private ObjectMetaBuilder metadata;
    private ServiceSpecBuilder spec;
    private ServiceStatusBuilder status;

    public ServiceFluentImpl(){
    }
    public ServiceFluentImpl(io.fabric8.knative.serving.v1beta1.Service instance){
            this.withApiVersion(instance.getApiVersion()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.withSpec(instance.getSpec()); 
            this.withStatus(instance.getStatus()); 
    }

    public String getApiVersion(){
            return this.apiVersion;
    }

    public A withApiVersion(String apiVersion){
            this.apiVersion=apiVersion; return (A) this;
    }

    public Boolean hasApiVersion(){
            return this.apiVersion != null;
    }

    public A withNewApiVersion(String arg1){
            return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuilder arg1){
            return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuffer arg1){
            return (A)withApiVersion(new String(arg1));
    }

    public String getKind(){
            return this.kind;
    }

    public A withKind(String kind){
            this.kind=kind; return (A) this;
    }

    public Boolean hasKind(){
            return this.kind != null;
    }

    public A withNewKind(String arg1){
            return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuilder arg1){
            return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuffer arg1){
            return (A)withKind(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public ObjectMeta getMetadata(){
            return this.metadata!=null?this.metadata.build():null;
    }

    public ObjectMeta buildMetadata(){
            return this.metadata!=null?this.metadata.build():null;
    }

    public A withMetadata(ObjectMeta metadata){
            _visitables.get("metadata").remove(this.metadata);
            if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.get("metadata").add(this.metadata);} return (A) this;
    }

    public Boolean hasMetadata(){
            return this.metadata != null;
    }

    public ServiceFluent.MetadataNested<A> withNewMetadata(){
            return new MetadataNestedImpl();
    }

    public ServiceFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item){
            return new MetadataNestedImpl(item);
    }

    public ServiceFluent.MetadataNested<A> editMetadata(){
            return withNewMetadataLike(getMetadata());
    }

    public ServiceFluent.MetadataNested<A> editOrNewMetadata(){
            return withNewMetadataLike(getMetadata() != null ? getMetadata(): new ObjectMetaBuilder().build());
    }

    public ServiceFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item){
            return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
    }

    
/**
 * This method has been deprecated, please use method buildSpec instead.
 * @return The buildable object.
 */
@Deprecated public ServiceSpec getSpec(){
            return this.spec!=null?this.spec.build():null;
    }

    public ServiceSpec buildSpec(){
            return this.spec!=null?this.spec.build():null;
    }

    public A withSpec(ServiceSpec spec){
            _visitables.get("spec").remove(this.spec);
            if (spec!=null){ this.spec= new ServiceSpecBuilder(spec); _visitables.get("spec").add(this.spec);} return (A) this;
    }

    public Boolean hasSpec(){
            return this.spec != null;
    }

    public ServiceFluent.SpecNested<A> withNewSpec(){
            return new SpecNestedImpl();
    }

    public ServiceFluent.SpecNested<A> withNewSpecLike(ServiceSpec item){
            return new SpecNestedImpl(item);
    }

    public ServiceFluent.SpecNested<A> editSpec(){
            return withNewSpecLike(getSpec());
    }

    public ServiceFluent.SpecNested<A> editOrNewSpec(){
            return withNewSpecLike(getSpec() != null ? getSpec(): new ServiceSpecBuilder().build());
    }

    public ServiceFluent.SpecNested<A> editOrNewSpecLike(ServiceSpec item){
            return withNewSpecLike(getSpec() != null ? getSpec(): item);
    }

    
/**
 * This method has been deprecated, please use method buildStatus instead.
 * @return The buildable object.
 */
@Deprecated public ServiceStatus getStatus(){
            return this.status!=null?this.status.build():null;
    }

    public ServiceStatus buildStatus(){
            return this.status!=null?this.status.build():null;
    }

    public A withStatus(ServiceStatus status){
            _visitables.get("status").remove(this.status);
            if (status!=null){ this.status= new ServiceStatusBuilder(status); _visitables.get("status").add(this.status);} return (A) this;
    }

    public Boolean hasStatus(){
            return this.status != null;
    }

    public ServiceFluent.StatusNested<A> withNewStatus(){
            return new StatusNestedImpl();
    }

    public ServiceFluent.StatusNested<A> withNewStatusLike(ServiceStatus item){
            return new StatusNestedImpl(item);
    }

    public ServiceFluent.StatusNested<A> editStatus(){
            return withNewStatusLike(getStatus());
    }

    public ServiceFluent.StatusNested<A> editOrNewStatus(){
            return withNewStatusLike(getStatus() != null ? getStatus(): new ServiceStatusBuilder().build());
    }

    public ServiceFluent.StatusNested<A> editOrNewStatusLike(ServiceStatus item){
            return withNewStatusLike(getStatus() != null ? getStatus(): item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ServiceFluentImpl that = (ServiceFluentImpl) o;
            if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
            if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
            if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
            if (spec != null ? !spec.equals(that.spec) :that.spec != null) return false;
            if (status != null ? !status.equals(that.status) :that.status != null) return false;
            return true;
    }


    public class MetadataNestedImpl<N> extends ObjectMetaFluentImpl<ServiceFluent.MetadataNested<N>> implements ServiceFluent.MetadataNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ObjectMetaBuilder builder;
    
            MetadataNestedImpl(ObjectMeta item){
                    this.builder = new ObjectMetaBuilder(this, item);
            }
            MetadataNestedImpl(){
                    this.builder = new ObjectMetaBuilder(this);
            }
    
    public N and(){
            return (N) ServiceFluentImpl.this.withMetadata(builder.build());
    }
    public N endMetadata(){
            return and();
    }

}
    public class SpecNestedImpl<N> extends ServiceSpecFluentImpl<ServiceFluent.SpecNested<N>> implements ServiceFluent.SpecNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ServiceSpecBuilder builder;
    
            SpecNestedImpl(ServiceSpec item){
                    this.builder = new ServiceSpecBuilder(this, item);
            }
            SpecNestedImpl(){
                    this.builder = new ServiceSpecBuilder(this);
            }
    
    public N and(){
            return (N) ServiceFluentImpl.this.withSpec(builder.build());
    }
    public N endSpec(){
            return and();
    }

}
    public class StatusNestedImpl<N> extends ServiceStatusFluentImpl<ServiceFluent.StatusNested<N>> implements ServiceFluent.StatusNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ServiceStatusBuilder builder;
    
            StatusNestedImpl(ServiceStatus item){
                    this.builder = new ServiceStatusBuilder(this, item);
            }
            StatusNestedImpl(){
                    this.builder = new ServiceStatusBuilder(this);
            }
    
    public N and(){
            return (N) ServiceFluentImpl.this.withStatus(builder.build());
    }
    public N endStatus(){
            return and();
    }

}


}
