package io.fabric8.knative.serving.v1;

import io.fabric8.knative.v1.Condition;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.knative.v1.ConditionFluent;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.knative.v1.ConditionBuilder;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface RevisionStatusFluent<A extends RevisionStatusFluent<A>> extends Fluent<A>{


    public A addToConditions(int index,Condition item);
    public A setToConditions(int index,Condition item);
    public A addToConditions(Condition... items);
    public A addAllToConditions(Collection<Condition> items);
    public A removeFromConditions(Condition... items);
    public A removeAllFromConditions(Collection<Condition> items);
    
/**
 * This method has been deprecated, please use method buildConditions instead.
 * @return The buildable object.
 */
@Deprecated public List<Condition> getConditions();
    public List<Condition> buildConditions();
    public Condition buildCondition(int index);
    public Condition buildFirstCondition();
    public Condition buildLastCondition();
    public Condition buildMatchingCondition(io.fabric8.kubernetes.api.builder.Predicate<ConditionBuilder> predicate);
    public Boolean hasMatchingCondition(io.fabric8.kubernetes.api.builder.Predicate<ConditionBuilder> predicate);
    public A withConditions(List<Condition> conditions);
    public A withConditions(Condition... conditions);
    public Boolean hasConditions();
    public RevisionStatusFluent.ConditionsNested<A> addNewCondition();
    public RevisionStatusFluent.ConditionsNested<A> addNewConditionLike(Condition item);
    public RevisionStatusFluent.ConditionsNested<A> setNewConditionLike(int index,Condition item);
    public RevisionStatusFluent.ConditionsNested<A> editCondition(int index);
    public RevisionStatusFluent.ConditionsNested<A> editFirstCondition();
    public RevisionStatusFluent.ConditionsNested<A> editLastCondition();
    public RevisionStatusFluent.ConditionsNested<A> editMatchingCondition(io.fabric8.kubernetes.api.builder.Predicate<ConditionBuilder> predicate);
    public String getImageDigest();
    public A withImageDigest(String imageDigest);
    public Boolean hasImageDigest();
    public A withNewImageDigest(String arg1);
    public A withNewImageDigest(StringBuilder arg1);
    public A withNewImageDigest(StringBuffer arg1);
    public String getLogUrl();
    public A withLogUrl(String logUrl);
    public Boolean hasLogUrl();
    public A withNewLogUrl(String arg1);
    public A withNewLogUrl(StringBuilder arg1);
    public A withNewLogUrl(StringBuffer arg1);
    public Long getObservedGeneration();
    public A withObservedGeneration(Long observedGeneration);
    public Boolean hasObservedGeneration();
    public String getServiceName();
    public A withServiceName(String serviceName);
    public Boolean hasServiceName();
    public A withNewServiceName(String arg1);
    public A withNewServiceName(StringBuilder arg1);
    public A withNewServiceName(StringBuffer arg1);

    public interface ConditionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ConditionFluent<RevisionStatusFluent.ConditionsNested<N>>{

        
    public N and();    public N endCondition();
}


}
