package io.fabric8.knative.eventing.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ReplyStrategyBuilder extends ReplyStrategyFluentImpl<ReplyStrategyBuilder> implements VisitableBuilder<ReplyStrategy,ReplyStrategyBuilder>{

    ReplyStrategyFluent<?> fluent;
    Boolean validationEnabled;

    public ReplyStrategyBuilder(){
            this(true);
    }
    public ReplyStrategyBuilder(Boolean validationEnabled){
            this(new ReplyStrategy(), validationEnabled);
    }
    public ReplyStrategyBuilder(ReplyStrategyFluent<?> fluent){
            this(fluent, true);
    }
    public ReplyStrategyBuilder(ReplyStrategyFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new ReplyStrategy(), validationEnabled);
    }
    public ReplyStrategyBuilder(ReplyStrategyFluent<?> fluent,ReplyStrategy instance){
            this(fluent, instance, true);
    }
    public ReplyStrategyBuilder(ReplyStrategyFluent<?> fluent,ReplyStrategy instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withChannel(instance.getChannel()); 
            this.validationEnabled = validationEnabled; 
    }
    public ReplyStrategyBuilder(ReplyStrategy instance){
            this(instance,true);
    }
    public ReplyStrategyBuilder(ReplyStrategy instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withChannel(instance.getChannel()); 
            this.validationEnabled = validationEnabled; 
    }

    public ReplyStrategy build(){
            ReplyStrategy buildable = new ReplyStrategy(fluent.getChannel());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ReplyStrategyBuilder that = (ReplyStrategyBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
