package io.fabric8.knative.serving.v1;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.knative.v1.URL;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.knative.duck.v1.AddressableFluentImpl;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.knative.v1.Condition;
import io.fabric8.knative.v1.URLBuilder;
import io.fabric8.knative.v1.URLFluentImpl;
import io.fabric8.knative.v1.ConditionBuilder;
import io.fabric8.knative.v1.ConditionFluentImpl;
import java.lang.StringBuffer;
import io.fabric8.knative.duck.v1.AddressableBuilder;
import java.lang.Long;
import io.fabric8.knative.duck.v1.Addressable;
import java.util.Collection;
import java.lang.Object;

public class ServiceStatusFluentImpl<A extends ServiceStatusFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements ServiceStatusFluent<A>{

    private AddressableBuilder address;
    private List<ConditionBuilder> conditions;
    private String latestCreatedRevisionName;
    private String latestReadyRevisionName;
    private Long observedGeneration;
    private List<TrafficTargetBuilder> traffic;
    private URLBuilder url;

    public ServiceStatusFluentImpl(){
    }
    public ServiceStatusFluentImpl(ServiceStatus instance){
            this.withAddress(instance.getAddress()); 
            this.withConditions(instance.getConditions()); 
            this.withLatestCreatedRevisionName(instance.getLatestCreatedRevisionName()); 
            this.withLatestReadyRevisionName(instance.getLatestReadyRevisionName()); 
            this.withObservedGeneration(instance.getObservedGeneration()); 
            this.withTraffic(instance.getTraffic()); 
            this.withUrl(instance.getUrl()); 
    }

    
/**
 * This method has been deprecated, please use method buildAddress instead.
 * @return The buildable object.
 */
@Deprecated public Addressable getAddress(){
            return this.address!=null?this.address.build():null;
    }

    public Addressable buildAddress(){
            return this.address!=null?this.address.build():null;
    }

    public A withAddress(Addressable address){
            _visitables.get("address").remove(this.address);
            if (address!=null){ this.address= new AddressableBuilder(address); _visitables.get("address").add(this.address);} return (A) this;
    }

    public Boolean hasAddress(){
            return this.address != null;
    }

    public ServiceStatusFluent.AddressNested<A> withNewAddress(){
            return new AddressNestedImpl();
    }

    public ServiceStatusFluent.AddressNested<A> withNewAddressLike(Addressable item){
            return new AddressNestedImpl(item);
    }

    public ServiceStatusFluent.AddressNested<A> editAddress(){
            return withNewAddressLike(getAddress());
    }

    public ServiceStatusFluent.AddressNested<A> editOrNewAddress(){
            return withNewAddressLike(getAddress() != null ? getAddress(): new AddressableBuilder().build());
    }

    public ServiceStatusFluent.AddressNested<A> editOrNewAddressLike(Addressable item){
            return withNewAddressLike(getAddress() != null ? getAddress(): item);
    }

    public A addToConditions(int index,Condition item){
            if (this.conditions == null) {this.conditions = new ArrayList<ConditionBuilder>();}
            ConditionBuilder builder = new ConditionBuilder(item);_visitables.get("conditions").add(index >= 0 ? index : _visitables.get("conditions").size(), builder);this.conditions.add(index >= 0 ? index : conditions.size(), builder); return (A)this;
    }

    public A setToConditions(int index,Condition item){
            if (this.conditions == null) {this.conditions = new ArrayList<ConditionBuilder>();}
            ConditionBuilder builder = new ConditionBuilder(item);
            if (index < 0 || index >= _visitables.get("conditions").size()) { _visitables.get("conditions").add(builder); } else { _visitables.get("conditions").set(index, builder);}
            if (index < 0 || index >= conditions.size()) { conditions.add(builder); } else { conditions.set(index, builder);}
             return (A)this;
    }

    public A addToConditions(Condition... items){
            if (this.conditions == null) {this.conditions = new ArrayList<ConditionBuilder>();}
            for (Condition item : items) {ConditionBuilder builder = new ConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
    }

    public A addAllToConditions(Collection<Condition> items){
            if (this.conditions == null) {this.conditions = new ArrayList<ConditionBuilder>();}
            for (Condition item : items) {ConditionBuilder builder = new ConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
    }

    public A removeFromConditions(Condition... items){
            for (Condition item : items) {ConditionBuilder builder = new ConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
    }

    public A removeAllFromConditions(Collection<Condition> items){
            for (Condition item : items) {ConditionBuilder builder = new ConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildConditions instead.
 * @return The buildable object.
 */
@Deprecated public List<Condition> getConditions(){
            return build(conditions);
    }

    public List<Condition> buildConditions(){
            return build(conditions);
    }

    public Condition buildCondition(int index){
            return this.conditions.get(index).build();
    }

    public Condition buildFirstCondition(){
            return this.conditions.get(0).build();
    }

    public Condition buildLastCondition(){
            return this.conditions.get(conditions.size() - 1).build();
    }

    public Condition buildMatchingCondition(io.fabric8.kubernetes.api.builder.Predicate<ConditionBuilder> predicate){
            for (ConditionBuilder item: conditions) { if(predicate.apply(item)){return item.build();} } return null;
    }

    public Boolean hasMatchingCondition(io.fabric8.kubernetes.api.builder.Predicate<ConditionBuilder> predicate){
            for (ConditionBuilder item: conditions) { if(predicate.apply(item)){return true;} } return false;
    }

    public A withConditions(List<Condition> conditions){
            if (this.conditions != null) { _visitables.get("conditions").removeAll(this.conditions);}
            if (conditions != null) {this.conditions = new ArrayList<ConditionBuilder>(); for (Condition item : conditions){this.addToConditions(item);}} else { this.conditions = new ArrayList<ConditionBuilder>();} return (A) this;
    }

    public A withConditions(Condition... conditions){
            if (this.conditions != null) {this.conditions.clear();}
            if (conditions != null) {for (Condition item :conditions){ this.addToConditions(item);}} return (A) this;
    }

    public Boolean hasConditions(){
            return conditions != null && !conditions.isEmpty();
    }

    public ServiceStatusFluent.ConditionsNested<A> addNewCondition(){
            return new ConditionsNestedImpl();
    }

    public ServiceStatusFluent.ConditionsNested<A> addNewConditionLike(Condition item){
            return new ConditionsNestedImpl(-1, item);
    }

    public ServiceStatusFluent.ConditionsNested<A> setNewConditionLike(int index,Condition item){
            return new ConditionsNestedImpl(index, item);
    }

    public ServiceStatusFluent.ConditionsNested<A> editCondition(int index){
            if (conditions.size() <= index) throw new RuntimeException("Can't edit conditions. Index exceeds size.");
            return setNewConditionLike(index, buildCondition(index));
    }

    public ServiceStatusFluent.ConditionsNested<A> editFirstCondition(){
            if (conditions.size() == 0) throw new RuntimeException("Can't edit first conditions. The list is empty.");
            return setNewConditionLike(0, buildCondition(0));
    }

    public ServiceStatusFluent.ConditionsNested<A> editLastCondition(){
            int index = conditions.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last conditions. The list is empty.");
            return setNewConditionLike(index, buildCondition(index));
    }

    public ServiceStatusFluent.ConditionsNested<A> editMatchingCondition(io.fabric8.kubernetes.api.builder.Predicate<ConditionBuilder> predicate){
            int index = -1;
            for (int i=0;i<conditions.size();i++) { 
            if (predicate.apply(conditions.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching conditions. No match found.");
            return setNewConditionLike(index, buildCondition(index));
    }

    public String getLatestCreatedRevisionName(){
            return this.latestCreatedRevisionName;
    }

    public A withLatestCreatedRevisionName(String latestCreatedRevisionName){
            this.latestCreatedRevisionName=latestCreatedRevisionName; return (A) this;
    }

    public Boolean hasLatestCreatedRevisionName(){
            return this.latestCreatedRevisionName != null;
    }

    public A withNewLatestCreatedRevisionName(String arg1){
            return (A)withLatestCreatedRevisionName(new String(arg1));
    }

    public A withNewLatestCreatedRevisionName(StringBuilder arg1){
            return (A)withLatestCreatedRevisionName(new String(arg1));
    }

    public A withNewLatestCreatedRevisionName(StringBuffer arg1){
            return (A)withLatestCreatedRevisionName(new String(arg1));
    }

    public String getLatestReadyRevisionName(){
            return this.latestReadyRevisionName;
    }

    public A withLatestReadyRevisionName(String latestReadyRevisionName){
            this.latestReadyRevisionName=latestReadyRevisionName; return (A) this;
    }

    public Boolean hasLatestReadyRevisionName(){
            return this.latestReadyRevisionName != null;
    }

    public A withNewLatestReadyRevisionName(String arg1){
            return (A)withLatestReadyRevisionName(new String(arg1));
    }

    public A withNewLatestReadyRevisionName(StringBuilder arg1){
            return (A)withLatestReadyRevisionName(new String(arg1));
    }

    public A withNewLatestReadyRevisionName(StringBuffer arg1){
            return (A)withLatestReadyRevisionName(new String(arg1));
    }

    public Long getObservedGeneration(){
            return this.observedGeneration;
    }

    public A withObservedGeneration(Long observedGeneration){
            this.observedGeneration=observedGeneration; return (A) this;
    }

    public Boolean hasObservedGeneration(){
            return this.observedGeneration != null;
    }

    public A addToTraffic(int index,TrafficTarget item){
            if (this.traffic == null) {this.traffic = new ArrayList<TrafficTargetBuilder>();}
            TrafficTargetBuilder builder = new TrafficTargetBuilder(item);_visitables.get("traffic").add(index >= 0 ? index : _visitables.get("traffic").size(), builder);this.traffic.add(index >= 0 ? index : traffic.size(), builder); return (A)this;
    }

    public A setToTraffic(int index,TrafficTarget item){
            if (this.traffic == null) {this.traffic = new ArrayList<TrafficTargetBuilder>();}
            TrafficTargetBuilder builder = new TrafficTargetBuilder(item);
            if (index < 0 || index >= _visitables.get("traffic").size()) { _visitables.get("traffic").add(builder); } else { _visitables.get("traffic").set(index, builder);}
            if (index < 0 || index >= traffic.size()) { traffic.add(builder); } else { traffic.set(index, builder);}
             return (A)this;
    }

    public A addToTraffic(TrafficTarget... items){
            if (this.traffic == null) {this.traffic = new ArrayList<TrafficTargetBuilder>();}
            for (TrafficTarget item : items) {TrafficTargetBuilder builder = new TrafficTargetBuilder(item);_visitables.get("traffic").add(builder);this.traffic.add(builder);} return (A)this;
    }

    public A addAllToTraffic(Collection<TrafficTarget> items){
            if (this.traffic == null) {this.traffic = new ArrayList<TrafficTargetBuilder>();}
            for (TrafficTarget item : items) {TrafficTargetBuilder builder = new TrafficTargetBuilder(item);_visitables.get("traffic").add(builder);this.traffic.add(builder);} return (A)this;
    }

    public A removeFromTraffic(TrafficTarget... items){
            for (TrafficTarget item : items) {TrafficTargetBuilder builder = new TrafficTargetBuilder(item);_visitables.get("traffic").remove(builder);if (this.traffic != null) {this.traffic.remove(builder);}} return (A)this;
    }

    public A removeAllFromTraffic(Collection<TrafficTarget> items){
            for (TrafficTarget item : items) {TrafficTargetBuilder builder = new TrafficTargetBuilder(item);_visitables.get("traffic").remove(builder);if (this.traffic != null) {this.traffic.remove(builder);}} return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildTraffic instead.
 * @return The buildable object.
 */
@Deprecated public List<TrafficTarget> getTraffic(){
            return build(traffic);
    }

    public List<TrafficTarget> buildTraffic(){
            return build(traffic);
    }

    public TrafficTarget buildTraffic(int index){
            return this.traffic.get(index).build();
    }

    public TrafficTarget buildFirstTraffic(){
            return this.traffic.get(0).build();
    }

    public TrafficTarget buildLastTraffic(){
            return this.traffic.get(traffic.size() - 1).build();
    }

    public TrafficTarget buildMatchingTraffic(io.fabric8.kubernetes.api.builder.Predicate<TrafficTargetBuilder> predicate){
            for (TrafficTargetBuilder item: traffic) { if(predicate.apply(item)){return item.build();} } return null;
    }

    public Boolean hasMatchingTraffic(io.fabric8.kubernetes.api.builder.Predicate<TrafficTargetBuilder> predicate){
            for (TrafficTargetBuilder item: traffic) { if(predicate.apply(item)){return true;} } return false;
    }

    public A withTraffic(List<TrafficTarget> traffic){
            if (this.traffic != null) { _visitables.get("traffic").removeAll(this.traffic);}
            if (traffic != null) {this.traffic = new ArrayList<TrafficTargetBuilder>(); for (TrafficTarget item : traffic){this.addToTraffic(item);}} else { this.traffic = new ArrayList<TrafficTargetBuilder>();} return (A) this;
    }

    public A withTraffic(TrafficTarget... traffic){
            if (this.traffic != null) {this.traffic.clear();}
            if (traffic != null) {for (TrafficTarget item :traffic){ this.addToTraffic(item);}} return (A) this;
    }

    public Boolean hasTraffic(){
            return traffic != null && !traffic.isEmpty();
    }

    public ServiceStatusFluent.TrafficNested<A> addNewTraffic(){
            return new TrafficNestedImpl();
    }

    public ServiceStatusFluent.TrafficNested<A> addNewTrafficLike(TrafficTarget item){
            return new TrafficNestedImpl(-1, item);
    }

    public ServiceStatusFluent.TrafficNested<A> setNewTrafficLike(int index,TrafficTarget item){
            return new TrafficNestedImpl(index, item);
    }

    public ServiceStatusFluent.TrafficNested<A> editTraffic(int index){
            if (traffic.size() <= index) throw new RuntimeException("Can't edit traffic. Index exceeds size.");
            return setNewTrafficLike(index, buildTraffic(index));
    }

    public ServiceStatusFluent.TrafficNested<A> editFirstTraffic(){
            if (traffic.size() == 0) throw new RuntimeException("Can't edit first traffic. The list is empty.");
            return setNewTrafficLike(0, buildTraffic(0));
    }

    public ServiceStatusFluent.TrafficNested<A> editLastTraffic(){
            int index = traffic.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last traffic. The list is empty.");
            return setNewTrafficLike(index, buildTraffic(index));
    }

    public ServiceStatusFluent.TrafficNested<A> editMatchingTraffic(io.fabric8.kubernetes.api.builder.Predicate<TrafficTargetBuilder> predicate){
            int index = -1;
            for (int i=0;i<traffic.size();i++) { 
            if (predicate.apply(traffic.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching traffic. No match found.");
            return setNewTrafficLike(index, buildTraffic(index));
    }

    
/**
 * This method has been deprecated, please use method buildUrl instead.
 * @return The buildable object.
 */
@Deprecated public URL getUrl(){
            return this.url!=null?this.url.build():null;
    }

    public URL buildUrl(){
            return this.url!=null?this.url.build():null;
    }

    public A withUrl(URL url){
            _visitables.get("url").remove(this.url);
            if (url!=null){ this.url= new URLBuilder(url); _visitables.get("url").add(this.url);} return (A) this;
    }

    public Boolean hasUrl(){
            return this.url != null;
    }

    public ServiceStatusFluent.UrlNested<A> withNewUrl(){
            return new UrlNestedImpl();
    }

    public ServiceStatusFluent.UrlNested<A> withNewUrlLike(URL item){
            return new UrlNestedImpl(item);
    }

    public ServiceStatusFluent.UrlNested<A> editUrl(){
            return withNewUrlLike(getUrl());
    }

    public ServiceStatusFluent.UrlNested<A> editOrNewUrl(){
            return withNewUrlLike(getUrl() != null ? getUrl(): new URLBuilder().build());
    }

    public ServiceStatusFluent.UrlNested<A> editOrNewUrlLike(URL item){
            return withNewUrlLike(getUrl() != null ? getUrl(): item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ServiceStatusFluentImpl that = (ServiceStatusFluentImpl) o;
            if (address != null ? !address.equals(that.address) :that.address != null) return false;
            if (conditions != null ? !conditions.equals(that.conditions) :that.conditions != null) return false;
            if (latestCreatedRevisionName != null ? !latestCreatedRevisionName.equals(that.latestCreatedRevisionName) :that.latestCreatedRevisionName != null) return false;
            if (latestReadyRevisionName != null ? !latestReadyRevisionName.equals(that.latestReadyRevisionName) :that.latestReadyRevisionName != null) return false;
            if (observedGeneration != null ? !observedGeneration.equals(that.observedGeneration) :that.observedGeneration != null) return false;
            if (traffic != null ? !traffic.equals(that.traffic) :that.traffic != null) return false;
            if (url != null ? !url.equals(that.url) :that.url != null) return false;
            return true;
    }


    public class AddressNestedImpl<N> extends AddressableFluentImpl<ServiceStatusFluent.AddressNested<N>> implements ServiceStatusFluent.AddressNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final AddressableBuilder builder;
    
            AddressNestedImpl(Addressable item){
                    this.builder = new AddressableBuilder(this, item);
            }
            AddressNestedImpl(){
                    this.builder = new AddressableBuilder(this);
            }
    
    public N and(){
            return (N) ServiceStatusFluentImpl.this.withAddress(builder.build());
    }
    public N endAddress(){
            return and();
    }

}
    public class ConditionsNestedImpl<N> extends ConditionFluentImpl<ServiceStatusFluent.ConditionsNested<N>> implements ServiceStatusFluent.ConditionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ConditionBuilder builder;
        private final int index;
    
            ConditionsNestedImpl(int index,Condition item){
                    this.index = index;
                    this.builder = new ConditionBuilder(this, item);
            }
            ConditionsNestedImpl(){
                    this.index = -1;
                    this.builder = new ConditionBuilder(this);
            }
    
    public N and(){
            return (N) ServiceStatusFluentImpl.this.setToConditions(index, builder.build());
    }
    public N endCondition(){
            return and();
    }

}
    public class TrafficNestedImpl<N> extends TrafficTargetFluentImpl<ServiceStatusFluent.TrafficNested<N>> implements ServiceStatusFluent.TrafficNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final TrafficTargetBuilder builder;
        private final int index;
    
            TrafficNestedImpl(int index,TrafficTarget item){
                    this.index = index;
                    this.builder = new TrafficTargetBuilder(this, item);
            }
            TrafficNestedImpl(){
                    this.index = -1;
                    this.builder = new TrafficTargetBuilder(this);
            }
    
    public N and(){
            return (N) ServiceStatusFluentImpl.this.setToTraffic(index, builder.build());
    }
    public N endTraffic(){
            return and();
    }

}
    public class UrlNestedImpl<N> extends URLFluentImpl<ServiceStatusFluent.UrlNested<N>> implements ServiceStatusFluent.UrlNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final URLBuilder builder;
    
            UrlNestedImpl(URL item){
                    this.builder = new URLBuilder(this, item);
            }
            UrlNestedImpl(){
                    this.builder = new URLBuilder(this);
            }
    
    public N and(){
            return (N) ServiceStatusFluentImpl.this.withUrl(builder.build());
    }
    public N endUrl(){
            return and();
    }

}


}
