package io.fabric8.knative.duck.v1alpha1;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class SubscribableFluentImpl<A extends SubscribableFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements SubscribableFluent<A>{

    private List<SubscriberSpecBuilder> subscribers;

    public SubscribableFluentImpl(){
    }
    public SubscribableFluentImpl(Subscribable instance){
            this.withSubscribers(instance.getSubscribers()); 
    }

    public A addToSubscribers(int index,SubscriberSpec item){
            if (this.subscribers == null) {this.subscribers = new ArrayList<SubscriberSpecBuilder>();}
            SubscriberSpecBuilder builder = new SubscriberSpecBuilder(item);_visitables.get("subscribers").add(index >= 0 ? index : _visitables.get("subscribers").size(), builder);this.subscribers.add(index >= 0 ? index : subscribers.size(), builder); return (A)this;
    }

    public A setToSubscribers(int index,SubscriberSpec item){
            if (this.subscribers == null) {this.subscribers = new ArrayList<SubscriberSpecBuilder>();}
            SubscriberSpecBuilder builder = new SubscriberSpecBuilder(item);
            if (index < 0 || index >= _visitables.get("subscribers").size()) { _visitables.get("subscribers").add(builder); } else { _visitables.get("subscribers").set(index, builder);}
            if (index < 0 || index >= subscribers.size()) { subscribers.add(builder); } else { subscribers.set(index, builder);}
             return (A)this;
    }

    public A addToSubscribers(SubscriberSpec... items){
            if (this.subscribers == null) {this.subscribers = new ArrayList<SubscriberSpecBuilder>();}
            for (SubscriberSpec item : items) {SubscriberSpecBuilder builder = new SubscriberSpecBuilder(item);_visitables.get("subscribers").add(builder);this.subscribers.add(builder);} return (A)this;
    }

    public A addAllToSubscribers(Collection<SubscriberSpec> items){
            if (this.subscribers == null) {this.subscribers = new ArrayList<SubscriberSpecBuilder>();}
            for (SubscriberSpec item : items) {SubscriberSpecBuilder builder = new SubscriberSpecBuilder(item);_visitables.get("subscribers").add(builder);this.subscribers.add(builder);} return (A)this;
    }

    public A removeFromSubscribers(SubscriberSpec... items){
            for (SubscriberSpec item : items) {SubscriberSpecBuilder builder = new SubscriberSpecBuilder(item);_visitables.get("subscribers").remove(builder);if (this.subscribers != null) {this.subscribers.remove(builder);}} return (A)this;
    }

    public A removeAllFromSubscribers(Collection<SubscriberSpec> items){
            for (SubscriberSpec item : items) {SubscriberSpecBuilder builder = new SubscriberSpecBuilder(item);_visitables.get("subscribers").remove(builder);if (this.subscribers != null) {this.subscribers.remove(builder);}} return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildSubscribers instead.
 * @return The buildable object.
 */
@Deprecated public List<SubscriberSpec> getSubscribers(){
            return build(subscribers);
    }

    public List<SubscriberSpec> buildSubscribers(){
            return build(subscribers);
    }

    public SubscriberSpec buildSubscriber(int index){
            return this.subscribers.get(index).build();
    }

    public SubscriberSpec buildFirstSubscriber(){
            return this.subscribers.get(0).build();
    }

    public SubscriberSpec buildLastSubscriber(){
            return this.subscribers.get(subscribers.size() - 1).build();
    }

    public SubscriberSpec buildMatchingSubscriber(io.fabric8.kubernetes.api.builder.Predicate<SubscriberSpecBuilder> predicate){
            for (SubscriberSpecBuilder item: subscribers) { if(predicate.apply(item)){return item.build();} } return null;
    }

    public Boolean hasMatchingSubscriber(io.fabric8.kubernetes.api.builder.Predicate<SubscriberSpecBuilder> predicate){
            for (SubscriberSpecBuilder item: subscribers) { if(predicate.apply(item)){return true;} } return false;
    }

    public A withSubscribers(List<SubscriberSpec> subscribers){
            if (this.subscribers != null) { _visitables.get("subscribers").removeAll(this.subscribers);}
            if (subscribers != null) {this.subscribers = new ArrayList<SubscriberSpecBuilder>(); for (SubscriberSpec item : subscribers){this.addToSubscribers(item);}} else { this.subscribers = new ArrayList<SubscriberSpecBuilder>();} return (A) this;
    }

    public A withSubscribers(SubscriberSpec... subscribers){
            if (this.subscribers != null) {this.subscribers.clear();}
            if (subscribers != null) {for (SubscriberSpec item :subscribers){ this.addToSubscribers(item);}} return (A) this;
    }

    public Boolean hasSubscribers(){
            return subscribers != null && !subscribers.isEmpty();
    }

    public SubscribableFluent.SubscribersNested<A> addNewSubscriber(){
            return new SubscribersNestedImpl();
    }

    public SubscribableFluent.SubscribersNested<A> addNewSubscriberLike(SubscriberSpec item){
            return new SubscribersNestedImpl(-1, item);
    }

    public SubscribableFluent.SubscribersNested<A> setNewSubscriberLike(int index,SubscriberSpec item){
            return new SubscribersNestedImpl(index, item);
    }

    public SubscribableFluent.SubscribersNested<A> editSubscriber(int index){
            if (subscribers.size() <= index) throw new RuntimeException("Can't edit subscribers. Index exceeds size.");
            return setNewSubscriberLike(index, buildSubscriber(index));
    }

    public SubscribableFluent.SubscribersNested<A> editFirstSubscriber(){
            if (subscribers.size() == 0) throw new RuntimeException("Can't edit first subscribers. The list is empty.");
            return setNewSubscriberLike(0, buildSubscriber(0));
    }

    public SubscribableFluent.SubscribersNested<A> editLastSubscriber(){
            int index = subscribers.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last subscribers. The list is empty.");
            return setNewSubscriberLike(index, buildSubscriber(index));
    }

    public SubscribableFluent.SubscribersNested<A> editMatchingSubscriber(io.fabric8.kubernetes.api.builder.Predicate<SubscriberSpecBuilder> predicate){
            int index = -1;
            for (int i=0;i<subscribers.size();i++) { 
            if (predicate.apply(subscribers.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching subscribers. No match found.");
            return setNewSubscriberLike(index, buildSubscriber(index));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            SubscribableFluentImpl that = (SubscribableFluentImpl) o;
            if (subscribers != null ? !subscribers.equals(that.subscribers) :that.subscribers != null) return false;
            return true;
    }


    public class SubscribersNestedImpl<N> extends SubscriberSpecFluentImpl<SubscribableFluent.SubscribersNested<N>> implements SubscribableFluent.SubscribersNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final SubscriberSpecBuilder builder;
        private final int index;
    
            SubscribersNestedImpl(int index,SubscriberSpec item){
                    this.index = index;
                    this.builder = new SubscriberSpecBuilder(this, item);
            }
            SubscribersNestedImpl(){
                    this.index = -1;
                    this.builder = new SubscriberSpecBuilder(this);
            }
    
    public N and(){
            return (N) SubscribableFluentImpl.this.setToSubscribers(index, builder.build());
    }
    public N endSubscriber(){
            return and();
    }

}


}
