package io.fabric8.knative.eventing.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class SubscriptionSpecBuilder extends SubscriptionSpecFluentImpl<SubscriptionSpecBuilder> implements VisitableBuilder<SubscriptionSpec,SubscriptionSpecBuilder>{

    SubscriptionSpecFluent<?> fluent;
    Boolean validationEnabled;

    public SubscriptionSpecBuilder(){
            this(true);
    }
    public SubscriptionSpecBuilder(Boolean validationEnabled){
            this(new SubscriptionSpec(), validationEnabled);
    }
    public SubscriptionSpecBuilder(SubscriptionSpecFluent<?> fluent){
            this(fluent, true);
    }
    public SubscriptionSpecBuilder(SubscriptionSpecFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new SubscriptionSpec(), validationEnabled);
    }
    public SubscriptionSpecBuilder(SubscriptionSpecFluent<?> fluent,SubscriptionSpec instance){
            this(fluent, instance, true);
    }
    public SubscriptionSpecBuilder(SubscriptionSpecFluent<?> fluent,SubscriptionSpec instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withChannel(instance.getChannel()); 
            fluent.withGeneration(instance.getGeneration()); 
            fluent.withReply(instance.getReply()); 
            fluent.withSubscriber(instance.getSubscriber()); 
            this.validationEnabled = validationEnabled; 
    }
    public SubscriptionSpecBuilder(SubscriptionSpec instance){
            this(instance,true);
    }
    public SubscriptionSpecBuilder(SubscriptionSpec instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withChannel(instance.getChannel()); 
            this.withGeneration(instance.getGeneration()); 
            this.withReply(instance.getReply()); 
            this.withSubscriber(instance.getSubscriber()); 
            this.validationEnabled = validationEnabled; 
    }

    public SubscriptionSpec build(){
            SubscriptionSpec buildable = new SubscriptionSpec(fluent.getChannel(),fluent.getGeneration(),fluent.getReply(),fluent.getSubscriber());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            SubscriptionSpecBuilder that = (SubscriptionSpecBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
