package io.fabric8.knative.serving.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ServiceStatusBuilder extends io.fabric8.knative.serving.v1alpha1.ServiceStatusFluentImpl<io.fabric8.knative.serving.v1alpha1.ServiceStatusBuilder> implements VisitableBuilder<io.fabric8.knative.serving.v1alpha1.ServiceStatus,io.fabric8.knative.serving.v1alpha1.ServiceStatusBuilder>{

    io.fabric8.knative.serving.v1alpha1.ServiceStatusFluent<?> fluent;
    Boolean validationEnabled;

    public ServiceStatusBuilder(){
            this(true);
    }
    public ServiceStatusBuilder(Boolean validationEnabled){
            this(new ServiceStatus(), validationEnabled);
    }
    public ServiceStatusBuilder(io.fabric8.knative.serving.v1alpha1.ServiceStatusFluent<?> fluent){
            this(fluent, true);
    }
    public ServiceStatusBuilder(io.fabric8.knative.serving.v1alpha1.ServiceStatusFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new ServiceStatus(), validationEnabled);
    }
    public ServiceStatusBuilder(io.fabric8.knative.serving.v1alpha1.ServiceStatusFluent<?> fluent,io.fabric8.knative.serving.v1alpha1.ServiceStatus instance){
            this(fluent, instance, true);
    }
    public ServiceStatusBuilder(io.fabric8.knative.serving.v1alpha1.ServiceStatusFluent<?> fluent,io.fabric8.knative.serving.v1alpha1.ServiceStatus instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withAddress(instance.getAddress()); 
            fluent.withConditions(instance.getConditions()); 
            fluent.withDomain(instance.getDomain()); 
            fluent.withDomainInternal(instance.getDomainInternal()); 
            fluent.withLatestCreatedRevisionName(instance.getLatestCreatedRevisionName()); 
            fluent.withLatestReadyRevisionName(instance.getLatestReadyRevisionName()); 
            fluent.withObservedGeneration(instance.getObservedGeneration()); 
            fluent.withTraffic(instance.getTraffic()); 
            fluent.withUrl(instance.getUrl()); 
            this.validationEnabled = validationEnabled; 
    }
    public ServiceStatusBuilder(io.fabric8.knative.serving.v1alpha1.ServiceStatus instance){
            this(instance,true);
    }
    public ServiceStatusBuilder(io.fabric8.knative.serving.v1alpha1.ServiceStatus instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withAddress(instance.getAddress()); 
            this.withConditions(instance.getConditions()); 
            this.withDomain(instance.getDomain()); 
            this.withDomainInternal(instance.getDomainInternal()); 
            this.withLatestCreatedRevisionName(instance.getLatestCreatedRevisionName()); 
            this.withLatestReadyRevisionName(instance.getLatestReadyRevisionName()); 
            this.withObservedGeneration(instance.getObservedGeneration()); 
            this.withTraffic(instance.getTraffic()); 
            this.withUrl(instance.getUrl()); 
            this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.knative.serving.v1alpha1.ServiceStatus build(){
            ServiceStatus buildable = new ServiceStatus(fluent.getAddress(),fluent.getConditions(),fluent.getDomain(),fluent.getDomainInternal(),fluent.getLatestCreatedRevisionName(),fluent.getLatestReadyRevisionName(),fluent.getObservedGeneration(),fluent.getTraffic(),fluent.getUrl());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ServiceStatusBuilder that = (ServiceStatusBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
