package io.fabric8.knative.serving.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ManualTypeBuilder extends ManualTypeFluentImpl<ManualTypeBuilder> implements VisitableBuilder<ManualType,ManualTypeBuilder>{

    ManualTypeFluent<?> fluent;
    Boolean validationEnabled;

    public ManualTypeBuilder(){
            this(true);
    }
    public ManualTypeBuilder(Boolean validationEnabled){
            this(new ManualType(), validationEnabled);
    }
    public ManualTypeBuilder(ManualTypeFluent<?> fluent){
            this(fluent, true);
    }
    public ManualTypeBuilder(ManualTypeFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new ManualType(), validationEnabled);
    }
    public ManualTypeBuilder(ManualTypeFluent<?> fluent,ManualType instance){
            this(fluent, instance, true);
    }
    public ManualTypeBuilder(ManualTypeFluent<?> fluent,ManualType instance,Boolean validationEnabled){
            this.fluent = fluent; 
            this.validationEnabled = validationEnabled; 
    }
    public ManualTypeBuilder(ManualType instance){
            this(instance,true);
    }
    public ManualTypeBuilder(ManualType instance,Boolean validationEnabled){
            this.fluent = this; 
            this.validationEnabled = validationEnabled; 
    }

    public ManualType build(){
            ManualType buildable = new ManualType();
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ManualTypeBuilder that = (ManualTypeBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
