
package io.fabric8.knative.serving.v1alpha1;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.Volume;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.builder.annotations.Inline;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@Generated("org.jsonschema2pojo")
@JsonPropertyOrder({
    "configuration",
    "revisions",
    "rolloutPercent"
})
@JsonDeserialize(using = com.fasterxml.jackson.databind.JsonDeserializer.None.class)
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, validationEnabled = false, generateBuilderPackage = false, builderPackage = "io.fabric8.kubernetes.api.builder", inline = {
    @Inline(type = Doneable.class, prefix = "Doneable", value = "done")
}, refs = {
    @BuildableReference(ObjectMeta.class),
    @BuildableReference(Volume.class),
    @BuildableReference(Container.class)
})
public class ReleaseType implements KubernetesResource
{

    /**
     * 
     * 
     */
    @JsonProperty("configuration")
    private ConfigurationSpec configuration;
    /**
     * 
     * 
     */
    @JsonProperty("revisions")
    private List<String> revisions = new ArrayList<String>();
    /**
     * 
     * 
     */
    @JsonProperty("rolloutPercent")
    private Integer rolloutPercent;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    /**
     * No args constructor for use in serialization
     * 
     */
    public ReleaseType() {
    }

    /**
     * 
     * @param configuration
     * @param revisions
     * @param rolloutPercent
     */
    public ReleaseType(ConfigurationSpec configuration, List<String> revisions, Integer rolloutPercent) {
        this.configuration = configuration;
        this.revisions = revisions;
        this.rolloutPercent = rolloutPercent;
    }

    /**
     * 
     * 
     * @return
     *     The configuration
     */
    @JsonProperty("configuration")
    public ConfigurationSpec getConfiguration() {
        return configuration;
    }

    /**
     * 
     * 
     * @param configuration
     *     The configuration
     */
    @JsonProperty("configuration")
    public void setConfiguration(ConfigurationSpec configuration) {
        this.configuration = configuration;
    }

    /**
     * 
     * 
     * @return
     *     The revisions
     */
    @JsonProperty("revisions")
    public List<String> getRevisions() {
        return revisions;
    }

    /**
     * 
     * 
     * @param revisions
     *     The revisions
     */
    @JsonProperty("revisions")
    public void setRevisions(List<String> revisions) {
        this.revisions = revisions;
    }

    /**
     * 
     * 
     * @return
     *     The rolloutPercent
     */
    @JsonProperty("rolloutPercent")
    public Integer getRolloutPercent() {
        return rolloutPercent;
    }

    /**
     * 
     * 
     * @param rolloutPercent
     *     The rolloutPercent
     */
    @JsonProperty("rolloutPercent")
    public void setRolloutPercent(Integer rolloutPercent) {
        this.rolloutPercent = rolloutPercent;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

}
