package io.fabric8.knative.duck.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Long;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class SubscribableStatusFluentImpl<A extends SubscribableStatusFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements SubscribableStatusFluent<A>{

    private List<SubscriberStatusBuilder> subscribers;

    public SubscribableStatusFluentImpl(){
    }
    public SubscribableStatusFluentImpl(SubscribableStatus instance){
            this.withSubscribers(instance.getSubscribers()); 
    }

    public A addToSubscribers(int index,SubscriberStatus item){
            if (this.subscribers == null) {this.subscribers = new ArrayList<SubscriberStatusBuilder>();}
            SubscriberStatusBuilder builder = new SubscriberStatusBuilder(item);_visitables.get("subscribers").add(index >= 0 ? index : _visitables.get("subscribers").size(), builder);this.subscribers.add(index >= 0 ? index : subscribers.size(), builder); return (A)this;
    }

    public A setToSubscribers(int index,SubscriberStatus item){
            if (this.subscribers == null) {this.subscribers = new ArrayList<SubscriberStatusBuilder>();}
            SubscriberStatusBuilder builder = new SubscriberStatusBuilder(item);
            if (index < 0 || index >= _visitables.get("subscribers").size()) { _visitables.get("subscribers").add(builder); } else { _visitables.get("subscribers").set(index, builder);}
            if (index < 0 || index >= subscribers.size()) { subscribers.add(builder); } else { subscribers.set(index, builder);}
             return (A)this;
    }

    public A addToSubscribers(SubscriberStatus... items){
            if (this.subscribers == null) {this.subscribers = new ArrayList<SubscriberStatusBuilder>();}
            for (SubscriberStatus item : items) {SubscriberStatusBuilder builder = new SubscriberStatusBuilder(item);_visitables.get("subscribers").add(builder);this.subscribers.add(builder);} return (A)this;
    }

    public A addAllToSubscribers(Collection<SubscriberStatus> items){
            if (this.subscribers == null) {this.subscribers = new ArrayList<SubscriberStatusBuilder>();}
            for (SubscriberStatus item : items) {SubscriberStatusBuilder builder = new SubscriberStatusBuilder(item);_visitables.get("subscribers").add(builder);this.subscribers.add(builder);} return (A)this;
    }

    public A removeFromSubscribers(SubscriberStatus... items){
            for (SubscriberStatus item : items) {SubscriberStatusBuilder builder = new SubscriberStatusBuilder(item);_visitables.get("subscribers").remove(builder);if (this.subscribers != null) {this.subscribers.remove(builder);}} return (A)this;
    }

    public A removeAllFromSubscribers(Collection<SubscriberStatus> items){
            for (SubscriberStatus item : items) {SubscriberStatusBuilder builder = new SubscriberStatusBuilder(item);_visitables.get("subscribers").remove(builder);if (this.subscribers != null) {this.subscribers.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromSubscribers(io.fabric8.kubernetes.api.builder.Predicate<SubscriberStatusBuilder> predicate){
            if (subscribers == null) return (A) this;
            final Iterator<SubscriberStatusBuilder> each = subscribers.iterator();
            final List visitables = _visitables.get("subscribers");
            while (each.hasNext()) {
              SubscriberStatusBuilder builder = each.next();
              if (predicate.apply(builder)) {
                visitables.remove(builder);
                each.remove();
              }
            }
            return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildSubscribers instead.
 * @return The buildable object.
 */
@Deprecated public List<SubscriberStatus> getSubscribers(){
            return build(subscribers);
    }

    public List<SubscriberStatus> buildSubscribers(){
            return build(subscribers);
    }

    public SubscriberStatus buildSubscriber(int index){
            return this.subscribers.get(index).build();
    }

    public SubscriberStatus buildFirstSubscriber(){
            return this.subscribers.get(0).build();
    }

    public SubscriberStatus buildLastSubscriber(){
            return this.subscribers.get(subscribers.size() - 1).build();
    }

    public SubscriberStatus buildMatchingSubscriber(io.fabric8.kubernetes.api.builder.Predicate<SubscriberStatusBuilder> predicate){
            for (SubscriberStatusBuilder item: subscribers) { if(predicate.apply(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingSubscriber(io.fabric8.kubernetes.api.builder.Predicate<SubscriberStatusBuilder> predicate){
            for (SubscriberStatusBuilder item: subscribers) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withSubscribers(List<SubscriberStatus> subscribers){
            if (this.subscribers != null) { _visitables.get("subscribers").removeAll(this.subscribers);}
            if (subscribers != null) {this.subscribers = new ArrayList<SubscriberStatusBuilder>(); for (SubscriberStatus item : subscribers){this.addToSubscribers(item);}} else { this.subscribers = null;} return (A) this;
    }

    public A withSubscribers(SubscriberStatus... subscribers){
            if (this.subscribers != null) {this.subscribers.clear();}
            if (subscribers != null) {for (SubscriberStatus item :subscribers){ this.addToSubscribers(item);}} return (A) this;
    }

    public Boolean hasSubscribers(){
            return subscribers != null && !subscribers.isEmpty();
    }

    public A addNewSubscriber(String message,Long observedGeneration,String ready,String uid){
            return (A)addToSubscribers(new SubscriberStatus(message, observedGeneration, ready, uid));
    }

    public SubscribableStatusFluent.SubscribersNested<A> addNewSubscriber(){
            return new SubscribersNestedImpl();
    }

    public SubscribableStatusFluent.SubscribersNested<A> addNewSubscriberLike(SubscriberStatus item){
            return new SubscribersNestedImpl(-1, item);
    }

    public SubscribableStatusFluent.SubscribersNested<A> setNewSubscriberLike(int index,SubscriberStatus item){
            return new SubscribersNestedImpl(index, item);
    }

    public SubscribableStatusFluent.SubscribersNested<A> editSubscriber(int index){
            if (subscribers.size() <= index) throw new RuntimeException("Can't edit subscribers. Index exceeds size.");
            return setNewSubscriberLike(index, buildSubscriber(index));
    }

    public SubscribableStatusFluent.SubscribersNested<A> editFirstSubscriber(){
            if (subscribers.size() == 0) throw new RuntimeException("Can't edit first subscribers. The list is empty.");
            return setNewSubscriberLike(0, buildSubscriber(0));
    }

    public SubscribableStatusFluent.SubscribersNested<A> editLastSubscriber(){
            int index = subscribers.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last subscribers. The list is empty.");
            return setNewSubscriberLike(index, buildSubscriber(index));
    }

    public SubscribableStatusFluent.SubscribersNested<A> editMatchingSubscriber(io.fabric8.kubernetes.api.builder.Predicate<SubscriberStatusBuilder> predicate){
            int index = -1;
            for (int i=0;i<subscribers.size();i++) { 
            if (predicate.apply(subscribers.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching subscribers. No match found.");
            return setNewSubscriberLike(index, buildSubscriber(index));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            SubscribableStatusFluentImpl that = (SubscribableStatusFluentImpl) o;
            if (subscribers != null ? !subscribers.equals(that.subscribers) :that.subscribers != null) return false;
            return true;
    }


    public class SubscribersNestedImpl<N> extends SubscriberStatusFluentImpl<SubscribableStatusFluent.SubscribersNested<N>> implements SubscribableStatusFluent.SubscribersNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final SubscriberStatusBuilder builder;
        private final int index;
    
            SubscribersNestedImpl(int index,SubscriberStatus item){
                    this.index = index;
                    this.builder = new SubscriberStatusBuilder(this, item);
            }
            SubscribersNestedImpl(){
                    this.index = -1;
                    this.builder = new SubscriberStatusBuilder(this);
            }
    
    public N and(){
            return (N) SubscribableStatusFluentImpl.this.setToSubscribers(index,builder.build());
    }
    public N endSubscriber(){
            return and();
    }

}


}
