package io.fabric8.knative.eventing.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class SubscriberSpecBuilder extends io.fabric8.knative.eventing.v1alpha1.SubscriberSpecFluentImpl<io.fabric8.knative.eventing.v1alpha1.SubscriberSpecBuilder> implements VisitableBuilder<io.fabric8.knative.eventing.v1alpha1.SubscriberSpec,io.fabric8.knative.eventing.v1alpha1.SubscriberSpecBuilder>{

    io.fabric8.knative.eventing.v1alpha1.SubscriberSpecFluent<?> fluent;
    Boolean validationEnabled;

    public SubscriberSpecBuilder(){
            this(true);
    }
    public SubscriberSpecBuilder(Boolean validationEnabled){
            this(new SubscriberSpec(), validationEnabled);
    }
    public SubscriberSpecBuilder(io.fabric8.knative.eventing.v1alpha1.SubscriberSpecFluent<?> fluent){
            this(fluent, true);
    }
    public SubscriberSpecBuilder(io.fabric8.knative.eventing.v1alpha1.SubscriberSpecFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new SubscriberSpec(), validationEnabled);
    }
    public SubscriberSpecBuilder(io.fabric8.knative.eventing.v1alpha1.SubscriberSpecFluent<?> fluent,io.fabric8.knative.eventing.v1alpha1.SubscriberSpec instance){
            this(fluent, instance, true);
    }
    public SubscriberSpecBuilder(io.fabric8.knative.eventing.v1alpha1.SubscriberSpecFluent<?> fluent,io.fabric8.knative.eventing.v1alpha1.SubscriberSpec instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withDnsName(instance.getDnsName()); 
            fluent.withRef(instance.getRef()); 
            fluent.withUri(instance.getUri()); 
            this.validationEnabled = validationEnabled; 
    }
    public SubscriberSpecBuilder(io.fabric8.knative.eventing.v1alpha1.SubscriberSpec instance){
            this(instance,true);
    }
    public SubscriberSpecBuilder(io.fabric8.knative.eventing.v1alpha1.SubscriberSpec instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withDnsName(instance.getDnsName()); 
            this.withRef(instance.getRef()); 
            this.withUri(instance.getUri()); 
            this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.knative.eventing.v1alpha1.SubscriberSpec build(){
            SubscriberSpec buildable = new SubscriberSpec(fluent.getDnsName(),fluent.getRef(),fluent.getUri());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            SubscriberSpecBuilder that = (SubscriberSpecBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
