package io.fabric8.knative.messaging.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.knative.eventing.v1alpha1.SubscriberSpecFluentImpl;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import io.fabric8.knative.eventing.v1alpha1.SubscriberSpec;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.kubernetes.api.model.ObjectReference;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.knative.eventing.v1alpha1.SubscriberSpecBuilder;
import java.util.Collection;
import java.lang.Object;

public class SequenceSpecFluentImpl<A extends SequenceSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements SequenceSpecFluent<A>{

    private io.fabric8.knative.messaging.v1alpha1.ChannelTemplateSpecBuilder channelTemplate;
    private ObjectReference reply;
    private List<io.fabric8.knative.eventing.v1alpha1.SubscriberSpecBuilder> steps;

    public SequenceSpecFluentImpl(){
    }
    public SequenceSpecFluentImpl(SequenceSpec instance){
            this.withChannelTemplate(instance.getChannelTemplate()); 
            this.withReply(instance.getReply()); 
            this.withSteps(instance.getSteps()); 
    }

    
/**
 * This method has been deprecated, please use method buildChannelTemplate instead.
 * @return The buildable object.
 */
@Deprecated public io.fabric8.knative.messaging.v1alpha1.ChannelTemplateSpec getChannelTemplate(){
            return this.channelTemplate!=null?this.channelTemplate.build():null;
    }

    public io.fabric8.knative.messaging.v1alpha1.ChannelTemplateSpec buildChannelTemplate(){
            return this.channelTemplate!=null?this.channelTemplate.build():null;
    }

    public A withChannelTemplate(io.fabric8.knative.messaging.v1alpha1.ChannelTemplateSpec channelTemplate){
            _visitables.get("channelTemplate").remove(this.channelTemplate);
            if (channelTemplate!=null){ this.channelTemplate= new io.fabric8.knative.messaging.v1alpha1.ChannelTemplateSpecBuilder(channelTemplate); _visitables.get("channelTemplate").add(this.channelTemplate);} return (A) this;
    }

    public Boolean hasChannelTemplate(){
            return this.channelTemplate != null;
    }

    public SequenceSpecFluent.ChannelTemplateNested<A> withNewChannelTemplate(){
            return new ChannelTemplateNestedImpl();
    }

    public SequenceSpecFluent.ChannelTemplateNested<A> withNewChannelTemplateLike(io.fabric8.knative.messaging.v1alpha1.ChannelTemplateSpec item){
            return new ChannelTemplateNestedImpl(item);
    }

    public SequenceSpecFluent.ChannelTemplateNested<A> editChannelTemplate(){
            return withNewChannelTemplateLike(getChannelTemplate());
    }

    public SequenceSpecFluent.ChannelTemplateNested<A> editOrNewChannelTemplate(){
            return withNewChannelTemplateLike(getChannelTemplate() != null ? getChannelTemplate(): new io.fabric8.knative.messaging.v1alpha1.ChannelTemplateSpecBuilder().build());
    }

    public SequenceSpecFluent.ChannelTemplateNested<A> editOrNewChannelTemplateLike(io.fabric8.knative.messaging.v1alpha1.ChannelTemplateSpec item){
            return withNewChannelTemplateLike(getChannelTemplate() != null ? getChannelTemplate(): item);
    }

    public ObjectReference getReply(){
            return this.reply;
    }

    public A withReply(ObjectReference reply){
            this.reply=reply; return (A) this;
    }

    public Boolean hasReply(){
            return this.reply != null;
    }

    public A addToSteps(int index,io.fabric8.knative.eventing.v1alpha1.SubscriberSpec item){
            if (this.steps == null) {this.steps = new ArrayList<io.fabric8.knative.eventing.v1alpha1.SubscriberSpecBuilder>();}
            io.fabric8.knative.eventing.v1alpha1.SubscriberSpecBuilder builder = new io.fabric8.knative.eventing.v1alpha1.SubscriberSpecBuilder(item);_visitables.get("steps").add(index >= 0 ? index : _visitables.get("steps").size(), builder);this.steps.add(index >= 0 ? index : steps.size(), builder); return (A)this;
    }

    public A setToSteps(int index,io.fabric8.knative.eventing.v1alpha1.SubscriberSpec item){
            if (this.steps == null) {this.steps = new ArrayList<io.fabric8.knative.eventing.v1alpha1.SubscriberSpecBuilder>();}
            io.fabric8.knative.eventing.v1alpha1.SubscriberSpecBuilder builder = new io.fabric8.knative.eventing.v1alpha1.SubscriberSpecBuilder(item);
            if (index < 0 || index >= _visitables.get("steps").size()) { _visitables.get("steps").add(builder); } else { _visitables.get("steps").set(index, builder);}
            if (index < 0 || index >= steps.size()) { steps.add(builder); } else { steps.set(index, builder);}
             return (A)this;
    }

    public A addToSteps(io.fabric8.knative.eventing.v1alpha1.SubscriberSpec... items){
            if (this.steps == null) {this.steps = new ArrayList<io.fabric8.knative.eventing.v1alpha1.SubscriberSpecBuilder>();}
            for (io.fabric8.knative.eventing.v1alpha1.SubscriberSpec item : items) {io.fabric8.knative.eventing.v1alpha1.SubscriberSpecBuilder builder = new io.fabric8.knative.eventing.v1alpha1.SubscriberSpecBuilder(item);_visitables.get("steps").add(builder);this.steps.add(builder);} return (A)this;
    }

    public A addAllToEventingSteps(Collection<io.fabric8.knative.eventing.v1alpha1.SubscriberSpec> items){
            if (this.steps == null) {this.steps = new ArrayList<io.fabric8.knative.eventing.v1alpha1.SubscriberSpecBuilder>();}
            for (io.fabric8.knative.eventing.v1alpha1.SubscriberSpec item : items) {io.fabric8.knative.eventing.v1alpha1.SubscriberSpecBuilder builder = new io.fabric8.knative.eventing.v1alpha1.SubscriberSpecBuilder(item);_visitables.get("steps").add(builder);this.steps.add(builder);} return (A)this;
    }

    public A removeFromSteps(io.fabric8.knative.eventing.v1alpha1.SubscriberSpec... items){
            for (io.fabric8.knative.eventing.v1alpha1.SubscriberSpec item : items) {io.fabric8.knative.eventing.v1alpha1.SubscriberSpecBuilder builder = new io.fabric8.knative.eventing.v1alpha1.SubscriberSpecBuilder(item);_visitables.get("steps").remove(builder);if (this.steps != null) {this.steps.remove(builder);}} return (A)this;
    }

    public A removeAllFromEventingSteps(Collection<io.fabric8.knative.eventing.v1alpha1.SubscriberSpec> items){
            for (io.fabric8.knative.eventing.v1alpha1.SubscriberSpec item : items) {io.fabric8.knative.eventing.v1alpha1.SubscriberSpecBuilder builder = new io.fabric8.knative.eventing.v1alpha1.SubscriberSpecBuilder(item);_visitables.get("steps").remove(builder);if (this.steps != null) {this.steps.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromEventingSteps(io.fabric8.kubernetes.api.builder.Predicate<io.fabric8.knative.eventing.v1alpha1.SubscriberSpecBuilder> predicate){
            if (steps == null) return (A) this;
            final Iterator<io.fabric8.knative.eventing.v1alpha1.SubscriberSpecBuilder> each = steps.iterator();
            final List visitables = _visitables.get("steps");
            while (each.hasNext()) {
              io.fabric8.knative.eventing.v1alpha1.SubscriberSpecBuilder builder = each.next();
              if (predicate.apply(builder)) {
                visitables.remove(builder);
                each.remove();
              }
            }
            return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildSteps instead.
 * @return The buildable object.
 */
@Deprecated public List<io.fabric8.knative.eventing.v1alpha1.SubscriberSpec> getSteps(){
            return build(steps);
    }

    public List<io.fabric8.knative.eventing.v1alpha1.SubscriberSpec> buildSteps(){
            return build(steps);
    }

    public io.fabric8.knative.eventing.v1alpha1.SubscriberSpec buildStep(int index){
            return this.steps.get(index).build();
    }

    public io.fabric8.knative.eventing.v1alpha1.SubscriberSpec buildFirstStep(){
            return this.steps.get(0).build();
    }

    public io.fabric8.knative.eventing.v1alpha1.SubscriberSpec buildLastStep(){
            return this.steps.get(steps.size() - 1).build();
    }

    public io.fabric8.knative.eventing.v1alpha1.SubscriberSpec buildMatchingStep(io.fabric8.kubernetes.api.builder.Predicate<io.fabric8.knative.eventing.v1alpha1.SubscriberSpecBuilder> predicate){
            for (io.fabric8.knative.eventing.v1alpha1.SubscriberSpecBuilder item: steps) { if(predicate.apply(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingStep(io.fabric8.kubernetes.api.builder.Predicate<io.fabric8.knative.eventing.v1alpha1.SubscriberSpecBuilder> predicate){
            for (io.fabric8.knative.eventing.v1alpha1.SubscriberSpecBuilder item: steps) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withSteps(List<io.fabric8.knative.eventing.v1alpha1.SubscriberSpec> steps){
            if (this.steps != null) { _visitables.get("steps").removeAll(this.steps);}
            if (steps != null) {this.steps = new ArrayList<io.fabric8.knative.eventing.v1alpha1.SubscriberSpecBuilder>(); for (io.fabric8.knative.eventing.v1alpha1.SubscriberSpec item : steps){this.addToSteps(item);}} else { this.steps = null;} return (A) this;
    }

    public A withSteps(io.fabric8.knative.eventing.v1alpha1.SubscriberSpec... steps){
            if (this.steps != null) {this.steps.clear();}
            if (steps != null) {for (io.fabric8.knative.eventing.v1alpha1.SubscriberSpec item :steps){ this.addToSteps(item);}} return (A) this;
    }

    public Boolean hasSteps(){
            return steps != null && !steps.isEmpty();
    }

    public SequenceSpecFluent.EventingStepsNested<A> addNewEventingStep(){
            return new EventingStepsNestedImpl();
    }

    public SequenceSpecFluent.EventingStepsNested<A> addNewStepLike(io.fabric8.knative.eventing.v1alpha1.SubscriberSpec item){
            return new EventingStepsNestedImpl(-1, item);
    }

    public SequenceSpecFluent.EventingStepsNested<A> setNewStepLike(int index,io.fabric8.knative.eventing.v1alpha1.SubscriberSpec item){
            return new EventingStepsNestedImpl(index, item);
    }

    public SequenceSpecFluent.EventingStepsNested<A> editStep(int index){
            if (steps.size() <= index) throw new RuntimeException("Can't edit steps. Index exceeds size.");
            return setNewStepLike(index, buildStep(index));
    }

    public SequenceSpecFluent.EventingStepsNested<A> editFirstStep(){
            if (steps.size() == 0) throw new RuntimeException("Can't edit first steps. The list is empty.");
            return setNewStepLike(0, buildStep(0));
    }

    public SequenceSpecFluent.EventingStepsNested<A> editLastStep(){
            int index = steps.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last steps. The list is empty.");
            return setNewStepLike(index, buildStep(index));
    }

    public SequenceSpecFluent.EventingStepsNested<A> editMatchingStep(io.fabric8.kubernetes.api.builder.Predicate<io.fabric8.knative.eventing.v1alpha1.SubscriberSpecBuilder> predicate){
            int index = -1;
            for (int i=0;i<steps.size();i++) { 
            if (predicate.apply(steps.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching steps. No match found.");
            return setNewStepLike(index, buildStep(index));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            SequenceSpecFluentImpl that = (SequenceSpecFluentImpl) o;
            if (channelTemplate != null ? !channelTemplate.equals(that.channelTemplate) :that.channelTemplate != null) return false;
            if (reply != null ? !reply.equals(that.reply) :that.reply != null) return false;
            if (steps != null ? !steps.equals(that.steps) :that.steps != null) return false;
            return true;
    }


    public class ChannelTemplateNestedImpl<N> extends io.fabric8.knative.messaging.v1alpha1.ChannelTemplateSpecFluentImpl<SequenceSpecFluent.ChannelTemplateNested<N>> implements SequenceSpecFluent.ChannelTemplateNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final io.fabric8.knative.messaging.v1alpha1.ChannelTemplateSpecBuilder builder;
    
            ChannelTemplateNestedImpl(io.fabric8.knative.messaging.v1alpha1.ChannelTemplateSpec item){
                    this.builder = new io.fabric8.knative.messaging.v1alpha1.ChannelTemplateSpecBuilder(this, item);
            }
            ChannelTemplateNestedImpl(){
                    this.builder = new io.fabric8.knative.messaging.v1alpha1.ChannelTemplateSpecBuilder(this);
            }
    
    public N and(){
            return (N) SequenceSpecFluentImpl.this.withChannelTemplate(builder.build());
    }
    public N endChannelTemplate(){
            return and();
    }

}
    public class EventingStepsNestedImpl<N> extends io.fabric8.knative.eventing.v1alpha1.SubscriberSpecFluentImpl<SequenceSpecFluent.EventingStepsNested<N>> implements SequenceSpecFluent.EventingStepsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final io.fabric8.knative.eventing.v1alpha1.SubscriberSpecBuilder builder;
        private final int index;
    
            EventingStepsNestedImpl(int index,io.fabric8.knative.eventing.v1alpha1.SubscriberSpec item){
                    this.index = index;
                    this.builder = new io.fabric8.knative.eventing.v1alpha1.SubscriberSpecBuilder(this, item);
            }
            EventingStepsNestedImpl(){
                    this.index = -1;
                    this.builder = new io.fabric8.knative.eventing.v1alpha1.SubscriberSpecBuilder(this);
            }
    
    public N and(){
            return (N) SequenceSpecFluentImpl.this.setToSteps(index,builder.build());
    }
    public N endEventingStep(){
            return and();
    }

}


}
