package io.fabric8.knative.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class KnativeSchemaBuilder extends KnativeSchemaFluentImpl<KnativeSchemaBuilder> implements VisitableBuilder<KnativeSchema,KnativeSchemaBuilder>{

    KnativeSchemaFluent<?> fluent;
    Boolean validationEnabled;

    public KnativeSchemaBuilder(){
            this(true);
    }
    public KnativeSchemaBuilder(Boolean validationEnabled){
            this(new KnativeSchema(), validationEnabled);
    }
    public KnativeSchemaBuilder(KnativeSchemaFluent<?> fluent){
            this(fluent, true);
    }
    public KnativeSchemaBuilder(KnativeSchemaFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new KnativeSchema(), validationEnabled);
    }
    public KnativeSchemaBuilder(KnativeSchemaFluent<?> fluent,KnativeSchema instance){
            this(fluent, instance, true);
    }
    public KnativeSchemaBuilder(KnativeSchemaFluent<?> fluent,KnativeSchema instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withBroker(instance.getBroker()); 
            fluent.withBrokerList(instance.getBrokerList()); 
            fluent.withChannel(instance.getChannel()); 
            fluent.withChannelList(instance.getChannelList()); 
            fluent.withClusterChannelProvisioner(instance.getClusterChannelProvisioner()); 
            fluent.withClusterChannelProvisionerList(instance.getClusterChannelProvisionerList()); 
            fluent.withEventType(instance.getEventType()); 
            fluent.withEventTypeList(instance.getEventTypeList()); 
            fluent.withInMemoryChannel(instance.getInMemoryChannel()); 
            fluent.withInMemoryChannelList(instance.getInMemoryChannelList()); 
            fluent.withSequence(instance.getSequence()); 
            fluent.withSequenceList(instance.getSequenceList()); 
            fluent.withSubscription(instance.getSubscription()); 
            fluent.withSubscriptionList(instance.getSubscriptionList()); 
            fluent.withTrigger(instance.getTrigger()); 
            fluent.withTriggerList(instance.getTriggerList()); 
            fluent.withV1Configuration(instance.getV1Configuration()); 
            fluent.withV1ConfigurationList(instance.getV1ConfigurationList()); 
            fluent.withV1Revision(instance.getV1Revision()); 
            fluent.withV1RevisionList(instance.getV1RevisionList()); 
            fluent.withV1Route(instance.getV1Route()); 
            fluent.withV1RouteList(instance.getV1RouteList()); 
            fluent.withV1Service(instance.getV1Service()); 
            fluent.withV1ServiceList(instance.getV1ServiceList()); 
            fluent.withV1alpha1Configuration(instance.getV1alpha1Configuration()); 
            fluent.withV1alpha1ConfigurationList(instance.getV1alpha1ConfigurationList()); 
            fluent.withV1alpha1Revision(instance.getV1alpha1Revision()); 
            fluent.withV1alpha1RevisionList(instance.getV1alpha1RevisionList()); 
            fluent.withV1alpha1Route(instance.getV1alpha1Route()); 
            fluent.withV1alpha1RouteList(instance.getV1alpha1RouteList()); 
            fluent.withV1alpha1Service(instance.getV1alpha1Service()); 
            fluent.withV1alpha1ServiceList(instance.getV1alpha1ServiceList()); 
            fluent.withV1beta1Configuration(instance.getV1beta1Configuration()); 
            fluent.withV1beta1ConfigurationList(instance.getV1beta1ConfigurationList()); 
            fluent.withV1beta1Revision(instance.getV1beta1Revision()); 
            fluent.withV1beta1RevisionList(instance.getV1beta1RevisionList()); 
            fluent.withV1beta1Route(instance.getV1beta1Route()); 
            fluent.withV1beta1RouteList(instance.getV1beta1RouteList()); 
            fluent.withV1beta1Service(instance.getV1beta1Service()); 
            fluent.withV1beta1ServiceList(instance.getV1beta1ServiceList()); 
            this.validationEnabled = validationEnabled; 
    }
    public KnativeSchemaBuilder(KnativeSchema instance){
            this(instance,true);
    }
    public KnativeSchemaBuilder(KnativeSchema instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withBroker(instance.getBroker()); 
            this.withBrokerList(instance.getBrokerList()); 
            this.withChannel(instance.getChannel()); 
            this.withChannelList(instance.getChannelList()); 
            this.withClusterChannelProvisioner(instance.getClusterChannelProvisioner()); 
            this.withClusterChannelProvisionerList(instance.getClusterChannelProvisionerList()); 
            this.withEventType(instance.getEventType()); 
            this.withEventTypeList(instance.getEventTypeList()); 
            this.withInMemoryChannel(instance.getInMemoryChannel()); 
            this.withInMemoryChannelList(instance.getInMemoryChannelList()); 
            this.withSequence(instance.getSequence()); 
            this.withSequenceList(instance.getSequenceList()); 
            this.withSubscription(instance.getSubscription()); 
            this.withSubscriptionList(instance.getSubscriptionList()); 
            this.withTrigger(instance.getTrigger()); 
            this.withTriggerList(instance.getTriggerList()); 
            this.withV1Configuration(instance.getV1Configuration()); 
            this.withV1ConfigurationList(instance.getV1ConfigurationList()); 
            this.withV1Revision(instance.getV1Revision()); 
            this.withV1RevisionList(instance.getV1RevisionList()); 
            this.withV1Route(instance.getV1Route()); 
            this.withV1RouteList(instance.getV1RouteList()); 
            this.withV1Service(instance.getV1Service()); 
            this.withV1ServiceList(instance.getV1ServiceList()); 
            this.withV1alpha1Configuration(instance.getV1alpha1Configuration()); 
            this.withV1alpha1ConfigurationList(instance.getV1alpha1ConfigurationList()); 
            this.withV1alpha1Revision(instance.getV1alpha1Revision()); 
            this.withV1alpha1RevisionList(instance.getV1alpha1RevisionList()); 
            this.withV1alpha1Route(instance.getV1alpha1Route()); 
            this.withV1alpha1RouteList(instance.getV1alpha1RouteList()); 
            this.withV1alpha1Service(instance.getV1alpha1Service()); 
            this.withV1alpha1ServiceList(instance.getV1alpha1ServiceList()); 
            this.withV1beta1Configuration(instance.getV1beta1Configuration()); 
            this.withV1beta1ConfigurationList(instance.getV1beta1ConfigurationList()); 
            this.withV1beta1Revision(instance.getV1beta1Revision()); 
            this.withV1beta1RevisionList(instance.getV1beta1RevisionList()); 
            this.withV1beta1Route(instance.getV1beta1Route()); 
            this.withV1beta1RouteList(instance.getV1beta1RouteList()); 
            this.withV1beta1Service(instance.getV1beta1Service()); 
            this.withV1beta1ServiceList(instance.getV1beta1ServiceList()); 
            this.validationEnabled = validationEnabled; 
    }

    public KnativeSchema build(){
            KnativeSchema buildable = new KnativeSchema(fluent.getBroker(),fluent.getBrokerList(),fluent.getChannel(),fluent.getChannelList(),fluent.getClusterChannelProvisioner(),fluent.getClusterChannelProvisionerList(),fluent.getEventType(),fluent.getEventTypeList(),fluent.getInMemoryChannel(),fluent.getInMemoryChannelList(),fluent.getSequence(),fluent.getSequenceList(),fluent.getSubscription(),fluent.getSubscriptionList(),fluent.getTrigger(),fluent.getTriggerList(),fluent.getV1Configuration(),fluent.getV1ConfigurationList(),fluent.getV1Revision(),fluent.getV1RevisionList(),fluent.getV1Route(),fluent.getV1RouteList(),fluent.getV1Service(),fluent.getV1ServiceList(),fluent.getV1alpha1Configuration(),fluent.getV1alpha1ConfigurationList(),fluent.getV1alpha1Revision(),fluent.getV1alpha1RevisionList(),fluent.getV1alpha1Route(),fluent.getV1alpha1RouteList(),fluent.getV1alpha1Service(),fluent.getV1alpha1ServiceList(),fluent.getV1beta1Configuration(),fluent.getV1beta1ConfigurationList(),fluent.getV1beta1Revision(),fluent.getV1beta1RevisionList(),fluent.getV1beta1Route(),fluent.getV1beta1RouteList(),fluent.getV1beta1Service(),fluent.getV1beta1ServiceList());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            KnativeSchemaBuilder that = (KnativeSchemaBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
