package io.fabric8.knative.eventing.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ClusterChannelProvisionerBuilder extends ClusterChannelProvisionerFluentImpl<ClusterChannelProvisionerBuilder> implements VisitableBuilder<ClusterChannelProvisioner,ClusterChannelProvisionerBuilder>{

    ClusterChannelProvisionerFluent<?> fluent;
    Boolean validationEnabled;

    public ClusterChannelProvisionerBuilder(){
            this(true);
    }
    public ClusterChannelProvisionerBuilder(Boolean validationEnabled){
            this(new ClusterChannelProvisioner(), validationEnabled);
    }
    public ClusterChannelProvisionerBuilder(ClusterChannelProvisionerFluent<?> fluent){
            this(fluent, true);
    }
    public ClusterChannelProvisionerBuilder(ClusterChannelProvisionerFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new ClusterChannelProvisioner(), validationEnabled);
    }
    public ClusterChannelProvisionerBuilder(ClusterChannelProvisionerFluent<?> fluent,ClusterChannelProvisioner instance){
            this(fluent, instance, true);
    }
    public ClusterChannelProvisionerBuilder(ClusterChannelProvisionerFluent<?> fluent,ClusterChannelProvisioner instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            fluent.withSpec(instance.getSpec()); 
            fluent.withStatus(instance.getStatus()); 
            this.validationEnabled = validationEnabled; 
    }
    public ClusterChannelProvisionerBuilder(ClusterChannelProvisioner instance){
            this(instance,true);
    }
    public ClusterChannelProvisionerBuilder(ClusterChannelProvisioner instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.withSpec(instance.getSpec()); 
            this.withStatus(instance.getStatus()); 
            this.validationEnabled = validationEnabled; 
    }

    public ClusterChannelProvisioner build(){
            ClusterChannelProvisioner buildable = new ClusterChannelProvisioner(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ClusterChannelProvisionerBuilder that = (ClusterChannelProvisionerBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
