package io.fabric8.knative.serving.v1alpha1;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.Integer;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class ReleaseTypeFluentImpl<A extends ReleaseTypeFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements ReleaseTypeFluent<A>{

    private io.fabric8.knative.serving.v1alpha1.ConfigurationSpecBuilder configuration;
    private List<String> revisions;
    private Integer rolloutPercent;

    public ReleaseTypeFluentImpl(){
    }
    public ReleaseTypeFluentImpl(ReleaseType instance){
            this.withConfiguration(instance.getConfiguration()); 
            this.withRevisions(instance.getRevisions()); 
            this.withRolloutPercent(instance.getRolloutPercent()); 
    }

    
/**
 * This method has been deprecated, please use method buildConfiguration instead.
 * @return The buildable object.
 */
@Deprecated public io.fabric8.knative.serving.v1alpha1.ConfigurationSpec getConfiguration(){
            return this.configuration!=null?this.configuration.build():null;
    }

    public io.fabric8.knative.serving.v1alpha1.ConfigurationSpec buildConfiguration(){
            return this.configuration!=null?this.configuration.build():null;
    }

    public A withConfiguration(io.fabric8.knative.serving.v1alpha1.ConfigurationSpec configuration){
            _visitables.get("configuration").remove(this.configuration);
            if (configuration!=null){ this.configuration= new io.fabric8.knative.serving.v1alpha1.ConfigurationSpecBuilder(configuration); _visitables.get("configuration").add(this.configuration);} return (A) this;
    }

    public Boolean hasConfiguration(){
            return this.configuration != null;
    }

    public ReleaseTypeFluent.ConfigurationNested<A> withNewConfiguration(){
            return new ConfigurationNestedImpl();
    }

    public ReleaseTypeFluent.ConfigurationNested<A> withNewConfigurationLike(io.fabric8.knative.serving.v1alpha1.ConfigurationSpec item){
            return new ConfigurationNestedImpl(item);
    }

    public ReleaseTypeFluent.ConfigurationNested<A> editConfiguration(){
            return withNewConfigurationLike(getConfiguration());
    }

    public ReleaseTypeFluent.ConfigurationNested<A> editOrNewConfiguration(){
            return withNewConfigurationLike(getConfiguration() != null ? getConfiguration(): new io.fabric8.knative.serving.v1alpha1.ConfigurationSpecBuilder().build());
    }

    public ReleaseTypeFluent.ConfigurationNested<A> editOrNewConfigurationLike(io.fabric8.knative.serving.v1alpha1.ConfigurationSpec item){
            return withNewConfigurationLike(getConfiguration() != null ? getConfiguration(): item);
    }

    public A addToRevisions(int index,String item){
            if (this.revisions == null) {this.revisions = new ArrayList<String>();}
            this.revisions.add(index, item);
            return (A)this;
    }

    public A setToRevisions(int index,String item){
            if (this.revisions == null) {this.revisions = new ArrayList<String>();}
            this.revisions.set(index, item); return (A)this;
    }

    public A addToRevisions(String... items){
            if (this.revisions == null) {this.revisions = new ArrayList<String>();}
            for (String item : items) {this.revisions.add(item);} return (A)this;
    }

    public A addAllToRevisions(Collection<String> items){
            if (this.revisions == null) {this.revisions = new ArrayList<String>();}
            for (String item : items) {this.revisions.add(item);} return (A)this;
    }

    public A removeFromRevisions(String... items){
            for (String item : items) {if (this.revisions!= null){ this.revisions.remove(item);}} return (A)this;
    }

    public A removeAllFromRevisions(Collection<String> items){
            for (String item : items) {if (this.revisions!= null){ this.revisions.remove(item);}} return (A)this;
    }

    public List<String> getRevisions(){
            return this.revisions;
    }

    public String getRevision(int index){
            return this.revisions.get(index);
    }

    public String getFirstRevision(){
            return this.revisions.get(0);
    }

    public String getLastRevision(){
            return this.revisions.get(revisions.size() - 1);
    }

    public String getMatchingRevision(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: revisions) { if(predicate.apply(item)){ return item;} } return null;
    }

    public Boolean hasMatchingRevision(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: revisions) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withRevisions(List<String> revisions){
            if (this.revisions != null) { _visitables.get("revisions").removeAll(this.revisions);}
            if (revisions != null) {this.revisions = new ArrayList<String>(); for (String item : revisions){this.addToRevisions(item);}} else { this.revisions = null;} return (A) this;
    }

    public A withRevisions(String... revisions){
            if (this.revisions != null) {this.revisions.clear();}
            if (revisions != null) {for (String item :revisions){ this.addToRevisions(item);}} return (A) this;
    }

    public Boolean hasRevisions(){
            return revisions != null && !revisions.isEmpty();
    }

    public A addNewRevision(String arg1){
            return (A)addToRevisions(new String(arg1));
    }

    public A addNewRevision(StringBuilder arg1){
            return (A)addToRevisions(new String(arg1));
    }

    public A addNewRevision(StringBuffer arg1){
            return (A)addToRevisions(new String(arg1));
    }

    public Integer getRolloutPercent(){
            return this.rolloutPercent;
    }

    public A withRolloutPercent(Integer rolloutPercent){
            this.rolloutPercent=rolloutPercent; return (A) this;
    }

    public Boolean hasRolloutPercent(){
            return this.rolloutPercent != null;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            ReleaseTypeFluentImpl that = (ReleaseTypeFluentImpl) o;
            if (configuration != null ? !configuration.equals(that.configuration) :that.configuration != null) return false;
            if (revisions != null ? !revisions.equals(that.revisions) :that.revisions != null) return false;
            if (rolloutPercent != null ? !rolloutPercent.equals(that.rolloutPercent) :that.rolloutPercent != null) return false;
            return true;
    }


    public class ConfigurationNestedImpl<N> extends io.fabric8.knative.serving.v1alpha1.ConfigurationSpecFluentImpl<ReleaseTypeFluent.ConfigurationNested<N>> implements ReleaseTypeFluent.ConfigurationNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final io.fabric8.knative.serving.v1alpha1.ConfigurationSpecBuilder builder;
    
            ConfigurationNestedImpl(io.fabric8.knative.serving.v1alpha1.ConfigurationSpec item){
                    this.builder = new io.fabric8.knative.serving.v1alpha1.ConfigurationSpecBuilder(this, item);
            }
            ConfigurationNestedImpl(){
                    this.builder = new io.fabric8.knative.serving.v1alpha1.ConfigurationSpecBuilder(this);
            }
    
    public N and(){
            return (N) ReleaseTypeFluentImpl.this.withConfiguration(builder.build());
    }
    public N endConfiguration(){
            return and();
    }

}


}
