
package io.fabric8.knative.serving.v1alpha1;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.Volume;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.builder.annotations.Inline;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@Generated("org.jsonschema2pojo")
@JsonPropertyOrder({
    "build",
    "generation",
    "manual",
    "pinned",
    "release",
    "revisionTemplate",
    "runLatest",
    "template",
    "traffic"
})
@JsonDeserialize(using = com.fasterxml.jackson.databind.JsonDeserializer.None.class)
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, validationEnabled = false, generateBuilderPackage = false, builderPackage = "io.fabric8.kubernetes.api.builder", inline = {
    @Inline(type = Doneable.class, prefix = "Doneable", value = "done")
}, refs = {
    @BuildableReference(ObjectMeta.class),
    @BuildableReference(Volume.class),
    @BuildableReference(Container.class)
})
public class ServiceSpec implements KubernetesResource
{

    /**
     * 
     * 
     */
    @JsonProperty("build")
    private Map<String, Object> build;
    /**
     * 
     * 
     */
    @JsonProperty("generation")
    private Long generation;
    /**
     * 
     * 
     */
    @JsonProperty("manual")
    private ManualType manual;
    /**
     * 
     * 
     */
    @JsonProperty("pinned")
    private PinnedType pinned;
    /**
     * 
     * 
     */
    @JsonProperty("release")
    private ReleaseType release;
    /**
     * 
     * 
     */
    @JsonProperty("revisionTemplate")
    private RevisionTemplateSpec revisionTemplate;
    /**
     * 
     * 
     */
    @JsonProperty("runLatest")
    private RunLatestType runLatest;
    /**
     * 
     * 
     */
    @JsonProperty("template")
    private RevisionTemplateSpec template;
    /**
     * 
     * 
     */
    @JsonProperty("traffic")
    private List<TrafficTarget> traffic = new ArrayList<TrafficTarget>();
    @JsonIgnore
    private Map<java.lang.String, java.lang.Object> additionalProperties = new HashMap<java.lang.String, java.lang.Object>();

    /**
     * No args constructor for use in serialization
     * 
     */
    public ServiceSpec() {
    }

    /**
     * 
     * @param generation
     * @param template
     * @param pinned
     * @param build
     * @param release
     * @param revisionTemplate
     * @param manual
     * @param runLatest
     * @param traffic
     */
    public ServiceSpec(Map<String, Object> build, Long generation, ManualType manual, PinnedType pinned, ReleaseType release, RevisionTemplateSpec revisionTemplate, RunLatestType runLatest, RevisionTemplateSpec template, List<TrafficTarget> traffic) {
        this.build = build;
        this.generation = generation;
        this.manual = manual;
        this.pinned = pinned;
        this.release = release;
        this.revisionTemplate = revisionTemplate;
        this.runLatest = runLatest;
        this.template = template;
        this.traffic = traffic;
    }

    /**
     * 
     * 
     * @return
     *     The build
     */
    @JsonProperty("build")
    public Map<String, Object> getBuild() {
        return build;
    }

    /**
     * 
     * 
     * @param build
     *     The build
     */
    @JsonProperty("build")
    public void setBuild(Map<String, Object> build) {
        this.build = build;
    }

    /**
     * 
     * 
     * @return
     *     The generation
     */
    @JsonProperty("generation")
    public Long getGeneration() {
        return generation;
    }

    /**
     * 
     * 
     * @param generation
     *     The generation
     */
    @JsonProperty("generation")
    public void setGeneration(Long generation) {
        this.generation = generation;
    }

    /**
     * 
     * 
     * @return
     *     The manual
     */
    @JsonProperty("manual")
    public ManualType getManual() {
        return manual;
    }

    /**
     * 
     * 
     * @param manual
     *     The manual
     */
    @JsonProperty("manual")
    public void setManual(ManualType manual) {
        this.manual = manual;
    }

    /**
     * 
     * 
     * @return
     *     The pinned
     */
    @JsonProperty("pinned")
    public PinnedType getPinned() {
        return pinned;
    }

    /**
     * 
     * 
     * @param pinned
     *     The pinned
     */
    @JsonProperty("pinned")
    public void setPinned(PinnedType pinned) {
        this.pinned = pinned;
    }

    /**
     * 
     * 
     * @return
     *     The release
     */
    @JsonProperty("release")
    public ReleaseType getRelease() {
        return release;
    }

    /**
     * 
     * 
     * @param release
     *     The release
     */
    @JsonProperty("release")
    public void setRelease(ReleaseType release) {
        this.release = release;
    }

    /**
     * 
     * 
     * @return
     *     The revisionTemplate
     */
    @JsonProperty("revisionTemplate")
    public RevisionTemplateSpec getRevisionTemplate() {
        return revisionTemplate;
    }

    /**
     * 
     * 
     * @param revisionTemplate
     *     The revisionTemplate
     */
    @JsonProperty("revisionTemplate")
    public void setRevisionTemplate(RevisionTemplateSpec revisionTemplate) {
        this.revisionTemplate = revisionTemplate;
    }

    /**
     * 
     * 
     * @return
     *     The runLatest
     */
    @JsonProperty("runLatest")
    public RunLatestType getRunLatest() {
        return runLatest;
    }

    /**
     * 
     * 
     * @param runLatest
     *     The runLatest
     */
    @JsonProperty("runLatest")
    public void setRunLatest(RunLatestType runLatest) {
        this.runLatest = runLatest;
    }

    /**
     * 
     * 
     * @return
     *     The template
     */
    @JsonProperty("template")
    public RevisionTemplateSpec getTemplate() {
        return template;
    }

    /**
     * 
     * 
     * @param template
     *     The template
     */
    @JsonProperty("template")
    public void setTemplate(RevisionTemplateSpec template) {
        this.template = template;
    }

    /**
     * 
     * 
     * @return
     *     The traffic
     */
    @JsonProperty("traffic")
    public List<TrafficTarget> getTraffic() {
        return traffic;
    }

    /**
     * 
     * 
     * @param traffic
     *     The traffic
     */
    @JsonProperty("traffic")
    public void setTraffic(List<TrafficTarget> traffic) {
        this.traffic = traffic;
    }

    @JsonAnyGetter
    public Map<java.lang.String, java.lang.Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(java.lang.String name, java.lang.Object value) {
        this.additionalProperties.put(name, value);
    }

}
