package io.fabric8.knative.eventing.v1alpha1;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ObjectReference;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Long;
import java.lang.Object;
import java.lang.Boolean;

public class SubscriptionSpecFluentImpl<A extends SubscriptionSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements SubscriptionSpecFluent<A>{

    private ObjectReference channel;
    private Long generation;
    private ReplyStrategyBuilder reply;
    private io.fabric8.knative.eventing.v1alpha1.SubscriberSpecBuilder subscriber;

    public SubscriptionSpecFluentImpl(){
    }
    public SubscriptionSpecFluentImpl(SubscriptionSpec instance){
            this.withChannel(instance.getChannel()); 
            this.withGeneration(instance.getGeneration()); 
            this.withReply(instance.getReply()); 
            this.withSubscriber(instance.getSubscriber()); 
    }

    public ObjectReference getChannel(){
            return this.channel;
    }

    public A withChannel(ObjectReference channel){
            this.channel=channel; return (A) this;
    }

    public Boolean hasChannel(){
            return this.channel != null;
    }

    public Long getGeneration(){
            return this.generation;
    }

    public A withGeneration(Long generation){
            this.generation=generation; return (A) this;
    }

    public Boolean hasGeneration(){
            return this.generation != null;
    }

    
/**
 * This method has been deprecated, please use method buildReply instead.
 * @return The buildable object.
 */
@Deprecated public ReplyStrategy getReply(){
            return this.reply!=null?this.reply.build():null;
    }

    public ReplyStrategy buildReply(){
            return this.reply!=null?this.reply.build():null;
    }

    public A withReply(ReplyStrategy reply){
            _visitables.get("reply").remove(this.reply);
            if (reply!=null){ this.reply= new ReplyStrategyBuilder(reply); _visitables.get("reply").add(this.reply);} return (A) this;
    }

    public Boolean hasReply(){
            return this.reply != null;
    }

    public SubscriptionSpecFluent.ReplyNested<A> withNewReply(){
            return new ReplyNestedImpl();
    }

    public SubscriptionSpecFluent.ReplyNested<A> withNewReplyLike(ReplyStrategy item){
            return new ReplyNestedImpl(item);
    }

    public SubscriptionSpecFluent.ReplyNested<A> editReply(){
            return withNewReplyLike(getReply());
    }

    public SubscriptionSpecFluent.ReplyNested<A> editOrNewReply(){
            return withNewReplyLike(getReply() != null ? getReply(): new ReplyStrategyBuilder().build());
    }

    public SubscriptionSpecFluent.ReplyNested<A> editOrNewReplyLike(ReplyStrategy item){
            return withNewReplyLike(getReply() != null ? getReply(): item);
    }

    
/**
 * This method has been deprecated, please use method buildSubscriber instead.
 * @return The buildable object.
 */
@Deprecated public io.fabric8.knative.eventing.v1alpha1.SubscriberSpec getSubscriber(){
            return this.subscriber!=null?this.subscriber.build():null;
    }

    public io.fabric8.knative.eventing.v1alpha1.SubscriberSpec buildSubscriber(){
            return this.subscriber!=null?this.subscriber.build():null;
    }

    public A withSubscriber(io.fabric8.knative.eventing.v1alpha1.SubscriberSpec subscriber){
            _visitables.get("subscriber").remove(this.subscriber);
            if (subscriber!=null){ this.subscriber= new io.fabric8.knative.eventing.v1alpha1.SubscriberSpecBuilder(subscriber); _visitables.get("subscriber").add(this.subscriber);} return (A) this;
    }

    public Boolean hasSubscriber(){
            return this.subscriber != null;
    }

    public SubscriptionSpecFluent.SubscriberNested<A> withNewSubscriber(){
            return new SubscriberNestedImpl();
    }

    public SubscriptionSpecFluent.SubscriberNested<A> withNewSubscriberLike(io.fabric8.knative.eventing.v1alpha1.SubscriberSpec item){
            return new SubscriberNestedImpl(item);
    }

    public SubscriptionSpecFluent.SubscriberNested<A> editSubscriber(){
            return withNewSubscriberLike(getSubscriber());
    }

    public SubscriptionSpecFluent.SubscriberNested<A> editOrNewSubscriber(){
            return withNewSubscriberLike(getSubscriber() != null ? getSubscriber(): new io.fabric8.knative.eventing.v1alpha1.SubscriberSpecBuilder().build());
    }

    public SubscriptionSpecFluent.SubscriberNested<A> editOrNewSubscriberLike(io.fabric8.knative.eventing.v1alpha1.SubscriberSpec item){
            return withNewSubscriberLike(getSubscriber() != null ? getSubscriber(): item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            SubscriptionSpecFluentImpl that = (SubscriptionSpecFluentImpl) o;
            if (channel != null ? !channel.equals(that.channel) :that.channel != null) return false;
            if (generation != null ? !generation.equals(that.generation) :that.generation != null) return false;
            if (reply != null ? !reply.equals(that.reply) :that.reply != null) return false;
            if (subscriber != null ? !subscriber.equals(that.subscriber) :that.subscriber != null) return false;
            return true;
    }


    public class ReplyNestedImpl<N> extends ReplyStrategyFluentImpl<SubscriptionSpecFluent.ReplyNested<N>> implements SubscriptionSpecFluent.ReplyNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ReplyStrategyBuilder builder;
    
            ReplyNestedImpl(ReplyStrategy item){
                    this.builder = new ReplyStrategyBuilder(this, item);
            }
            ReplyNestedImpl(){
                    this.builder = new ReplyStrategyBuilder(this);
            }
    
    public N and(){
            return (N) SubscriptionSpecFluentImpl.this.withReply(builder.build());
    }
    public N endReply(){
            return and();
    }

}
    public class SubscriberNestedImpl<N> extends io.fabric8.knative.eventing.v1alpha1.SubscriberSpecFluentImpl<SubscriptionSpecFluent.SubscriberNested<N>> implements SubscriptionSpecFluent.SubscriberNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final io.fabric8.knative.eventing.v1alpha1.SubscriberSpecBuilder builder;
    
            SubscriberNestedImpl(io.fabric8.knative.eventing.v1alpha1.SubscriberSpec item){
                    this.builder = new io.fabric8.knative.eventing.v1alpha1.SubscriberSpecBuilder(this, item);
            }
            SubscriberNestedImpl(){
                    this.builder = new io.fabric8.knative.eventing.v1alpha1.SubscriberSpecBuilder(this);
            }
    
    public N and(){
            return (N) SubscriptionSpecFluentImpl.this.withSubscriber(builder.build());
    }
    public N endSubscriber(){
            return and();
    }

}


}
