package io.fabric8.knative.eventing.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ClusterChannelProvisionerSpecBuilder extends ClusterChannelProvisionerSpecFluentImpl<ClusterChannelProvisionerSpecBuilder> implements VisitableBuilder<ClusterChannelProvisionerSpec,ClusterChannelProvisionerSpecBuilder>{

    ClusterChannelProvisionerSpecFluent<?> fluent;
    Boolean validationEnabled;

    public ClusterChannelProvisionerSpecBuilder(){
            this(true);
    }
    public ClusterChannelProvisionerSpecBuilder(Boolean validationEnabled){
            this(new ClusterChannelProvisionerSpec(), validationEnabled);
    }
    public ClusterChannelProvisionerSpecBuilder(ClusterChannelProvisionerSpecFluent<?> fluent){
            this(fluent, true);
    }
    public ClusterChannelProvisionerSpecBuilder(ClusterChannelProvisionerSpecFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new ClusterChannelProvisionerSpec(), validationEnabled);
    }
    public ClusterChannelProvisionerSpecBuilder(ClusterChannelProvisionerSpecFluent<?> fluent,ClusterChannelProvisionerSpec instance){
            this(fluent, instance, true);
    }
    public ClusterChannelProvisionerSpecBuilder(ClusterChannelProvisionerSpecFluent<?> fluent,ClusterChannelProvisionerSpec instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withGeneration(instance.getGeneration()); 
            this.validationEnabled = validationEnabled; 
    }
    public ClusterChannelProvisionerSpecBuilder(ClusterChannelProvisionerSpec instance){
            this(instance,true);
    }
    public ClusterChannelProvisionerSpecBuilder(ClusterChannelProvisionerSpec instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withGeneration(instance.getGeneration()); 
            this.validationEnabled = validationEnabled; 
    }

    public ClusterChannelProvisionerSpec build(){
            ClusterChannelProvisionerSpec buildable = new ClusterChannelProvisionerSpec(fluent.getGeneration());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ClusterChannelProvisionerSpecBuilder that = (ClusterChannelProvisionerSpecBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
