package io.fabric8.knative.net;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class UserinfoBuilder extends UserinfoFluentImpl<UserinfoBuilder> implements VisitableBuilder<Userinfo,UserinfoBuilder>{

    UserinfoFluent<?> fluent;
    Boolean validationEnabled;

    public UserinfoBuilder(){
            this(true);
    }
    public UserinfoBuilder(Boolean validationEnabled){
            this(new Userinfo(), validationEnabled);
    }
    public UserinfoBuilder(UserinfoFluent<?> fluent){
            this(fluent, true);
    }
    public UserinfoBuilder(UserinfoFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new Userinfo(), validationEnabled);
    }
    public UserinfoBuilder(UserinfoFluent<?> fluent,Userinfo instance){
            this(fluent, instance, true);
    }
    public UserinfoBuilder(UserinfoFluent<?> fluent,Userinfo instance,Boolean validationEnabled){
            this.fluent = fluent; 
            this.validationEnabled = validationEnabled; 
    }
    public UserinfoBuilder(Userinfo instance){
            this(instance,true);
    }
    public UserinfoBuilder(Userinfo instance,Boolean validationEnabled){
            this.fluent = this; 
            this.validationEnabled = validationEnabled; 
    }

    public Userinfo build(){
            Userinfo buildable = new Userinfo();
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            UserinfoBuilder that = (UserinfoBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
