package io.fabric8.knative.messaging.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class SequenceChannelStatusBuilder extends SequenceChannelStatusFluentImpl<SequenceChannelStatusBuilder> implements VisitableBuilder<SequenceChannelStatus,SequenceChannelStatusBuilder>{

    SequenceChannelStatusFluent<?> fluent;
    Boolean validationEnabled;

    public SequenceChannelStatusBuilder(){
            this(true);
    }
    public SequenceChannelStatusBuilder(Boolean validationEnabled){
            this(new SequenceChannelStatus(), validationEnabled);
    }
    public SequenceChannelStatusBuilder(SequenceChannelStatusFluent<?> fluent){
            this(fluent, true);
    }
    public SequenceChannelStatusBuilder(SequenceChannelStatusFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new SequenceChannelStatus(), validationEnabled);
    }
    public SequenceChannelStatusBuilder(SequenceChannelStatusFluent<?> fluent,SequenceChannelStatus instance){
            this(fluent, instance, true);
    }
    public SequenceChannelStatusBuilder(SequenceChannelStatusFluent<?> fluent,SequenceChannelStatus instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withChannel(instance.getChannel()); 
            fluent.withReady(instance.getReady()); 
            this.validationEnabled = validationEnabled; 
    }
    public SequenceChannelStatusBuilder(SequenceChannelStatus instance){
            this(instance,true);
    }
    public SequenceChannelStatusBuilder(SequenceChannelStatus instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withChannel(instance.getChannel()); 
            this.withReady(instance.getReady()); 
            this.validationEnabled = validationEnabled; 
    }

    public SequenceChannelStatus build(){
            SequenceChannelStatus buildable = new SequenceChannelStatus(fluent.getChannel(),fluent.getReady());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            SequenceChannelStatusBuilder that = (SequenceChannelStatusBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
