package io.fabric8.knative.duck.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class SubscriberSpecBuilder extends SubscriberSpecFluentImpl<SubscriberSpecBuilder> implements VisitableBuilder<SubscriberSpec,SubscriberSpecBuilder>{

    SubscriberSpecFluent<?> fluent;
    Boolean validationEnabled;

    public SubscriberSpecBuilder(){
            this(true);
    }
    public SubscriberSpecBuilder(Boolean validationEnabled){
            this(new SubscriberSpec(), validationEnabled);
    }
    public SubscriberSpecBuilder(SubscriberSpecFluent<?> fluent){
            this(fluent, true);
    }
    public SubscriberSpecBuilder(SubscriberSpecFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new SubscriberSpec(), validationEnabled);
    }
    public SubscriberSpecBuilder(SubscriberSpecFluent<?> fluent,SubscriberSpec instance){
            this(fluent, instance, true);
    }
    public SubscriberSpecBuilder(SubscriberSpecFluent<?> fluent,SubscriberSpec instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withGeneration(instance.getGeneration()); 
            fluent.withRef(instance.getRef()); 
            fluent.withReplyURI(instance.getReplyURI()); 
            fluent.withSubscriberURI(instance.getSubscriberURI()); 
            fluent.withUid(instance.getUid()); 
            this.validationEnabled = validationEnabled; 
    }
    public SubscriberSpecBuilder(SubscriberSpec instance){
            this(instance,true);
    }
    public SubscriberSpecBuilder(SubscriberSpec instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withGeneration(instance.getGeneration()); 
            this.withRef(instance.getRef()); 
            this.withReplyURI(instance.getReplyURI()); 
            this.withSubscriberURI(instance.getSubscriberURI()); 
            this.withUid(instance.getUid()); 
            this.validationEnabled = validationEnabled; 
    }

    public SubscriberSpec build(){
            SubscriberSpec buildable = new SubscriberSpec(fluent.getGeneration(),fluent.getRef(),fluent.getReplyURI(),fluent.getSubscriberURI(),fluent.getUid());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            SubscriberSpecBuilder that = (SubscriberSpecBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
