package io.fabric8.knative.eventing.v1alpha1;

import java.lang.StringBuffer;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;
import java.util.Map;
import java.util.LinkedHashMap;

public class ChannelTemplateSpecFluentImpl<A extends ChannelTemplateSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements ChannelTemplateSpecFluent<A>{

    private String apiVersion;
    private String kind;
    private Map<String,Object> spec;

    public ChannelTemplateSpecFluentImpl(){
    }
    public ChannelTemplateSpecFluentImpl(ChannelTemplateSpec instance){
            this.withApiVersion(instance.getApiVersion()); 
            this.withKind(instance.getKind()); 
            this.withSpec(instance.getSpec()); 
    }

    public String getApiVersion(){
            return this.apiVersion;
    }

    public A withApiVersion(String apiVersion){
            this.apiVersion=apiVersion; return (A) this;
    }

    public Boolean hasApiVersion(){
            return this.apiVersion != null;
    }

    public A withNewApiVersion(String arg1){
            return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuilder arg1){
            return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuffer arg1){
            return (A)withApiVersion(new String(arg1));
    }

    public String getKind(){
            return this.kind;
    }

    public A withKind(String kind){
            this.kind=kind; return (A) this;
    }

    public Boolean hasKind(){
            return this.kind != null;
    }

    public A withNewKind(String arg1){
            return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuilder arg1){
            return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuffer arg1){
            return (A)withKind(new String(arg1));
    }

    public A addToSpec(String key,Object value){
            if(this.spec == null && key != null && value != null) { this.spec = new LinkedHashMap<String,Object>(); }
            if(key != null && value != null) {this.spec.put(key, value);} return (A)this;
    }

    public A addToSpec(Map<String,Object> map){
            if(this.spec == null && map != null) { this.spec = new LinkedHashMap<String,Object>(); }
            if(map != null) { this.spec.putAll(map);} return (A)this;
    }

    public A removeFromSpec(String key){
            if(this.spec == null) { return (A) this; }
            if(key != null && this.spec != null) {this.spec.remove(key);} return (A)this;
    }

    public A removeFromSpec(Map<String,Object> map){
            if(this.spec == null) { return (A) this; }
            if(map != null) { for(Object key : map.keySet()) {if (this.spec != null){this.spec.remove(key);}}} return (A)this;
    }

    public Map<String,Object> getSpec(){
            return this.spec;
    }

    public A withSpec(Map<String,Object> spec){
            if (spec == null) { this.spec =  null;} else {this.spec = new LinkedHashMap<String,Object>(spec);} return (A) this;
    }

    public Boolean hasSpec(){
            return this.spec != null;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            ChannelTemplateSpecFluentImpl that = (ChannelTemplateSpecFluentImpl) o;
            if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
            if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
            if (spec != null ? !spec.equals(that.spec) :that.spec != null) return false;
            return true;
    }




}
