package io.fabric8.knative.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class URLBuilder extends URLFluentImpl<URLBuilder> implements VisitableBuilder<URL,URLBuilder>{

    URLFluent<?> fluent;
    Boolean validationEnabled;

    public URLBuilder(){
            this(true);
    }
    public URLBuilder(Boolean validationEnabled){
            this(new URL(), validationEnabled);
    }
    public URLBuilder(URLFluent<?> fluent){
            this(fluent, true);
    }
    public URLBuilder(URLFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new URL(), validationEnabled);
    }
    public URLBuilder(URLFluent<?> fluent,URL instance){
            this(fluent, instance, true);
    }
    public URLBuilder(URLFluent<?> fluent,URL instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withForceQuery(instance.getForceQuery()); 
            fluent.withFragment(instance.getFragment()); 
            fluent.withHost(instance.getHost()); 
            fluent.withOpaque(instance.getOpaque()); 
            fluent.withPath(instance.getPath()); 
            fluent.withRawPath(instance.getRawPath()); 
            fluent.withRawQuery(instance.getRawQuery()); 
            fluent.withScheme(instance.getScheme()); 
            fluent.withUser(instance.getUser()); 
            this.validationEnabled = validationEnabled; 
    }
    public URLBuilder(URL instance){
            this(instance,true);
    }
    public URLBuilder(URL instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withForceQuery(instance.getForceQuery()); 
            this.withFragment(instance.getFragment()); 
            this.withHost(instance.getHost()); 
            this.withOpaque(instance.getOpaque()); 
            this.withPath(instance.getPath()); 
            this.withRawPath(instance.getRawPath()); 
            this.withRawQuery(instance.getRawQuery()); 
            this.withScheme(instance.getScheme()); 
            this.withUser(instance.getUser()); 
            this.validationEnabled = validationEnabled; 
    }

    public URL build(){
            URL buildable = new URL(fluent.isForceQuery(),fluent.getFragment(),fluent.getHost(),fluent.getOpaque(),fluent.getPath(),fluent.getRawPath(),fluent.getRawQuery(),fluent.getScheme(),fluent.getUser());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            URLBuilder that = (URLBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
