package io.fabric8.knative.duck.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ChannelableSpecBuilder extends ChannelableSpecFluentImpl<ChannelableSpecBuilder> implements VisitableBuilder<ChannelableSpec,ChannelableSpecBuilder>{

    ChannelableSpecFluent<?> fluent;
    Boolean validationEnabled;

    public ChannelableSpecBuilder(){
            this(true);
    }
    public ChannelableSpecBuilder(Boolean validationEnabled){
            this(new ChannelableSpec(), validationEnabled);
    }
    public ChannelableSpecBuilder(ChannelableSpecFluent<?> fluent){
            this(fluent, true);
    }
    public ChannelableSpecBuilder(ChannelableSpecFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new ChannelableSpec(), validationEnabled);
    }
    public ChannelableSpecBuilder(ChannelableSpecFluent<?> fluent,ChannelableSpec instance){
            this(fluent, instance, true);
    }
    public ChannelableSpecBuilder(ChannelableSpecFluent<?> fluent,ChannelableSpec instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withDelivery(instance.getDelivery()); 
            fluent.withSubscribable(instance.getSubscribable()); 
            this.validationEnabled = validationEnabled; 
    }
    public ChannelableSpecBuilder(ChannelableSpec instance){
            this(instance,true);
    }
    public ChannelableSpecBuilder(ChannelableSpec instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withDelivery(instance.getDelivery()); 
            this.withSubscribable(instance.getSubscribable()); 
            this.validationEnabled = validationEnabled; 
    }

    public ChannelableSpec build(){
            ChannelableSpec buildable = new ChannelableSpec(fluent.getDelivery(),fluent.getSubscribable());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ChannelableSpecBuilder that = (ChannelableSpecBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
