package io.fabric8.knative.duck.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.knative.duck.v1.AddressableFluentImpl;
import io.fabric8.knative.duck.v1.KReference;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.knative.duck.v1.KReferenceFluentImpl;
import io.fabric8.knative.v1.Condition;
import io.fabric8.knative.v1.ConditionBuilder;
import io.fabric8.knative.v1.ConditionFluentImpl;
import io.fabric8.knative.duck.v1.KReferenceBuilder;
import io.fabric8.knative.duck.v1.AddressableBuilder;
import java.lang.Long;
import io.fabric8.knative.duck.v1.Addressable;
import java.util.Collection;
import java.lang.Object;

public class ChannelableStatusFluentImpl<A extends io.fabric8.knative.duck.v1beta1.ChannelableStatusFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.knative.duck.v1beta1.ChannelableStatusFluent<A>{

    private AddressableBuilder address;
    private List<ConditionBuilder> conditions;
    private KReferenceBuilder deadLetterChannel;
    private Long observedGeneration;
    private List<io.fabric8.knative.duck.v1beta1.SubscriberStatusBuilder> subscribers;

    public ChannelableStatusFluentImpl(){
    }
    public ChannelableStatusFluentImpl(io.fabric8.knative.duck.v1beta1.ChannelableStatus instance){
            this.withAddress(instance.getAddress()); 
            this.withConditions(instance.getConditions()); 
            this.withDeadLetterChannel(instance.getDeadLetterChannel()); 
            this.withObservedGeneration(instance.getObservedGeneration()); 
            this.withSubscribers(instance.getSubscribers()); 
    }

    
/**
 * This method has been deprecated, please use method buildAddress instead.
 * @return The buildable object.
 */
@java.lang.Deprecated public Addressable getAddress(){
            return this.address!=null?this.address.build():null;
    }

    public Addressable buildAddress(){
            return this.address!=null?this.address.build():null;
    }

    public A withAddress(Addressable address){
            _visitables.get("address").remove(this.address);
            if (address!=null){ this.address= new AddressableBuilder(address); _visitables.get("address").add(this.address);} return (A) this;
    }

    public Boolean hasAddress(){
            return this.address != null;
    }

    public ChannelableStatusFluent.AddressNested<A> withNewAddress(){
            return new AddressNestedImpl();
    }

    public ChannelableStatusFluent.AddressNested<A> withNewAddressLike(Addressable item){
            return new AddressNestedImpl(item);
    }

    public ChannelableStatusFluent.AddressNested<A> editAddress(){
            return withNewAddressLike(getAddress());
    }

    public ChannelableStatusFluent.AddressNested<A> editOrNewAddress(){
            return withNewAddressLike(getAddress() != null ? getAddress(): new AddressableBuilder().build());
    }

    public ChannelableStatusFluent.AddressNested<A> editOrNewAddressLike(Addressable item){
            return withNewAddressLike(getAddress() != null ? getAddress(): item);
    }

    public A addToConditions(int index,Condition item){
            if (this.conditions == null) {this.conditions = new ArrayList<ConditionBuilder>();}
            ConditionBuilder builder = new ConditionBuilder(item);_visitables.get("conditions").add(index >= 0 ? index : _visitables.get("conditions").size(), builder);this.conditions.add(index >= 0 ? index : conditions.size(), builder); return (A)this;
    }

    public A setToConditions(int index,Condition item){
            if (this.conditions == null) {this.conditions = new ArrayList<ConditionBuilder>();}
            ConditionBuilder builder = new ConditionBuilder(item);
            if (index < 0 || index >= _visitables.get("conditions").size()) { _visitables.get("conditions").add(builder); } else { _visitables.get("conditions").set(index, builder);}
            if (index < 0 || index >= conditions.size()) { conditions.add(builder); } else { conditions.set(index, builder);}
             return (A)this;
    }

    public A addToConditions(Condition... items){
            if (this.conditions == null) {this.conditions = new ArrayList<ConditionBuilder>();}
            for (Condition item : items) {ConditionBuilder builder = new ConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
    }

    public A addAllToConditions(Collection<Condition> items){
            if (this.conditions == null) {this.conditions = new ArrayList<ConditionBuilder>();}
            for (Condition item : items) {ConditionBuilder builder = new ConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
    }

    public A removeFromConditions(Condition... items){
            for (Condition item : items) {ConditionBuilder builder = new ConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
    }

    public A removeAllFromConditions(Collection<Condition> items){
            for (Condition item : items) {ConditionBuilder builder = new ConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromConditions(io.fabric8.kubernetes.api.builder.Predicate<ConditionBuilder> predicate){
            if (conditions == null) return (A) this;
            final Iterator<ConditionBuilder> each = conditions.iterator();
            final List visitables = _visitables.get("conditions");
            while (each.hasNext()) {
              ConditionBuilder builder = each.next();
              if (predicate.apply(builder)) {
                visitables.remove(builder);
                each.remove();
              }
            }
            return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildConditions instead.
 * @return The buildable object.
 */
@java.lang.Deprecated public List<Condition> getConditions(){
            return build(conditions);
    }

    public List<Condition> buildConditions(){
            return build(conditions);
    }

    public Condition buildCondition(int index){
            return this.conditions.get(index).build();
    }

    public Condition buildFirstCondition(){
            return this.conditions.get(0).build();
    }

    public Condition buildLastCondition(){
            return this.conditions.get(conditions.size() - 1).build();
    }

    public Condition buildMatchingCondition(io.fabric8.kubernetes.api.builder.Predicate<ConditionBuilder> predicate){
            for (ConditionBuilder item: conditions) { if(predicate.apply(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingCondition(io.fabric8.kubernetes.api.builder.Predicate<ConditionBuilder> predicate){
            for (ConditionBuilder item: conditions) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withConditions(List<Condition> conditions){
            if (this.conditions != null) { _visitables.get("conditions").removeAll(this.conditions);}
            if (conditions != null) {this.conditions = new ArrayList<ConditionBuilder>(); for (Condition item : conditions){this.addToConditions(item);}} else { this.conditions = null;} return (A) this;
    }

    public A withConditions(Condition... conditions){
            if (this.conditions != null) {this.conditions.clear();}
            if (conditions != null) {for (Condition item :conditions){ this.addToConditions(item);}} return (A) this;
    }

    public Boolean hasConditions(){
            return conditions != null && !conditions.isEmpty();
    }

    public ChannelableStatusFluent.ConditionsNested<A> addNewCondition(){
            return new ConditionsNestedImpl();
    }

    public ChannelableStatusFluent.ConditionsNested<A> addNewConditionLike(Condition item){
            return new ConditionsNestedImpl(-1, item);
    }

    public ChannelableStatusFluent.ConditionsNested<A> setNewConditionLike(int index,Condition item){
            return new ConditionsNestedImpl(index, item);
    }

    public ChannelableStatusFluent.ConditionsNested<A> editCondition(int index){
            if (conditions.size() <= index) throw new RuntimeException("Can't edit conditions. Index exceeds size.");
            return setNewConditionLike(index, buildCondition(index));
    }

    public ChannelableStatusFluent.ConditionsNested<A> editFirstCondition(){
            if (conditions.size() == 0) throw new RuntimeException("Can't edit first conditions. The list is empty.");
            return setNewConditionLike(0, buildCondition(0));
    }

    public ChannelableStatusFluent.ConditionsNested<A> editLastCondition(){
            int index = conditions.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last conditions. The list is empty.");
            return setNewConditionLike(index, buildCondition(index));
    }

    public ChannelableStatusFluent.ConditionsNested<A> editMatchingCondition(io.fabric8.kubernetes.api.builder.Predicate<ConditionBuilder> predicate){
            int index = -1;
            for (int i=0;i<conditions.size();i++) { 
            if (predicate.apply(conditions.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching conditions. No match found.");
            return setNewConditionLike(index, buildCondition(index));
    }

    
/**
 * This method has been deprecated, please use method buildDeadLetterChannel instead.
 * @return The buildable object.
 */
@java.lang.Deprecated public KReference getDeadLetterChannel(){
            return this.deadLetterChannel!=null?this.deadLetterChannel.build():null;
    }

    public KReference buildDeadLetterChannel(){
            return this.deadLetterChannel!=null?this.deadLetterChannel.build():null;
    }

    public A withDeadLetterChannel(KReference deadLetterChannel){
            _visitables.get("deadLetterChannel").remove(this.deadLetterChannel);
            if (deadLetterChannel!=null){ this.deadLetterChannel= new KReferenceBuilder(deadLetterChannel); _visitables.get("deadLetterChannel").add(this.deadLetterChannel);} return (A) this;
    }

    public Boolean hasDeadLetterChannel(){
            return this.deadLetterChannel != null;
    }

    public A withNewDeadLetterChannel(String apiVersion,String kind,String name,String namespace){
            return (A)withDeadLetterChannel(new KReference(apiVersion, kind, name, namespace));
    }

    public ChannelableStatusFluent.DeadLetterChannelNested<A> withNewDeadLetterChannel(){
            return new DeadLetterChannelNestedImpl();
    }

    public ChannelableStatusFluent.DeadLetterChannelNested<A> withNewDeadLetterChannelLike(KReference item){
            return new DeadLetterChannelNestedImpl(item);
    }

    public ChannelableStatusFluent.DeadLetterChannelNested<A> editDeadLetterChannel(){
            return withNewDeadLetterChannelLike(getDeadLetterChannel());
    }

    public ChannelableStatusFluent.DeadLetterChannelNested<A> editOrNewDeadLetterChannel(){
            return withNewDeadLetterChannelLike(getDeadLetterChannel() != null ? getDeadLetterChannel(): new KReferenceBuilder().build());
    }

    public ChannelableStatusFluent.DeadLetterChannelNested<A> editOrNewDeadLetterChannelLike(KReference item){
            return withNewDeadLetterChannelLike(getDeadLetterChannel() != null ? getDeadLetterChannel(): item);
    }

    public Long getObservedGeneration(){
            return this.observedGeneration;
    }

    public A withObservedGeneration(Long observedGeneration){
            this.observedGeneration=observedGeneration; return (A) this;
    }

    public Boolean hasObservedGeneration(){
            return this.observedGeneration != null;
    }

    public A addToSubscribers(int index,io.fabric8.knative.duck.v1beta1.SubscriberStatus item){
            if (this.subscribers == null) {this.subscribers = new ArrayList<io.fabric8.knative.duck.v1beta1.SubscriberStatusBuilder>();}
            io.fabric8.knative.duck.v1beta1.SubscriberStatusBuilder builder = new io.fabric8.knative.duck.v1beta1.SubscriberStatusBuilder(item);_visitables.get("subscribers").add(index >= 0 ? index : _visitables.get("subscribers").size(), builder);this.subscribers.add(index >= 0 ? index : subscribers.size(), builder); return (A)this;
    }

    public A setToSubscribers(int index,io.fabric8.knative.duck.v1beta1.SubscriberStatus item){
            if (this.subscribers == null) {this.subscribers = new ArrayList<io.fabric8.knative.duck.v1beta1.SubscriberStatusBuilder>();}
            io.fabric8.knative.duck.v1beta1.SubscriberStatusBuilder builder = new io.fabric8.knative.duck.v1beta1.SubscriberStatusBuilder(item);
            if (index < 0 || index >= _visitables.get("subscribers").size()) { _visitables.get("subscribers").add(builder); } else { _visitables.get("subscribers").set(index, builder);}
            if (index < 0 || index >= subscribers.size()) { subscribers.add(builder); } else { subscribers.set(index, builder);}
             return (A)this;
    }

    public A addToSubscribers(io.fabric8.knative.duck.v1beta1.SubscriberStatus... items){
            if (this.subscribers == null) {this.subscribers = new ArrayList<io.fabric8.knative.duck.v1beta1.SubscriberStatusBuilder>();}
            for (io.fabric8.knative.duck.v1beta1.SubscriberStatus item : items) {io.fabric8.knative.duck.v1beta1.SubscriberStatusBuilder builder = new io.fabric8.knative.duck.v1beta1.SubscriberStatusBuilder(item);_visitables.get("subscribers").add(builder);this.subscribers.add(builder);} return (A)this;
    }

    public A addAllToSubscribers(Collection<io.fabric8.knative.duck.v1beta1.SubscriberStatus> items){
            if (this.subscribers == null) {this.subscribers = new ArrayList<io.fabric8.knative.duck.v1beta1.SubscriberStatusBuilder>();}
            for (io.fabric8.knative.duck.v1beta1.SubscriberStatus item : items) {io.fabric8.knative.duck.v1beta1.SubscriberStatusBuilder builder = new io.fabric8.knative.duck.v1beta1.SubscriberStatusBuilder(item);_visitables.get("subscribers").add(builder);this.subscribers.add(builder);} return (A)this;
    }

    public A removeFromSubscribers(io.fabric8.knative.duck.v1beta1.SubscriberStatus... items){
            for (io.fabric8.knative.duck.v1beta1.SubscriberStatus item : items) {io.fabric8.knative.duck.v1beta1.SubscriberStatusBuilder builder = new io.fabric8.knative.duck.v1beta1.SubscriberStatusBuilder(item);_visitables.get("subscribers").remove(builder);if (this.subscribers != null) {this.subscribers.remove(builder);}} return (A)this;
    }

    public A removeAllFromSubscribers(Collection<io.fabric8.knative.duck.v1beta1.SubscriberStatus> items){
            for (io.fabric8.knative.duck.v1beta1.SubscriberStatus item : items) {io.fabric8.knative.duck.v1beta1.SubscriberStatusBuilder builder = new io.fabric8.knative.duck.v1beta1.SubscriberStatusBuilder(item);_visitables.get("subscribers").remove(builder);if (this.subscribers != null) {this.subscribers.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromSubscribers(io.fabric8.kubernetes.api.builder.Predicate<io.fabric8.knative.duck.v1beta1.SubscriberStatusBuilder> predicate){
            if (subscribers == null) return (A) this;
            final Iterator<io.fabric8.knative.duck.v1beta1.SubscriberStatusBuilder> each = subscribers.iterator();
            final List visitables = _visitables.get("subscribers");
            while (each.hasNext()) {
              io.fabric8.knative.duck.v1beta1.SubscriberStatusBuilder builder = each.next();
              if (predicate.apply(builder)) {
                visitables.remove(builder);
                each.remove();
              }
            }
            return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildSubscribers instead.
 * @return The buildable object.
 */
@java.lang.Deprecated public List<io.fabric8.knative.duck.v1beta1.SubscriberStatus> getSubscribers(){
            return build(subscribers);
    }

    public List<io.fabric8.knative.duck.v1beta1.SubscriberStatus> buildSubscribers(){
            return build(subscribers);
    }

    public io.fabric8.knative.duck.v1beta1.SubscriberStatus buildSubscriber(int index){
            return this.subscribers.get(index).build();
    }

    public io.fabric8.knative.duck.v1beta1.SubscriberStatus buildFirstSubscriber(){
            return this.subscribers.get(0).build();
    }

    public io.fabric8.knative.duck.v1beta1.SubscriberStatus buildLastSubscriber(){
            return this.subscribers.get(subscribers.size() - 1).build();
    }

    public io.fabric8.knative.duck.v1beta1.SubscriberStatus buildMatchingSubscriber(io.fabric8.kubernetes.api.builder.Predicate<io.fabric8.knative.duck.v1beta1.SubscriberStatusBuilder> predicate){
            for (io.fabric8.knative.duck.v1beta1.SubscriberStatusBuilder item: subscribers) { if(predicate.apply(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingSubscriber(io.fabric8.kubernetes.api.builder.Predicate<io.fabric8.knative.duck.v1beta1.SubscriberStatusBuilder> predicate){
            for (io.fabric8.knative.duck.v1beta1.SubscriberStatusBuilder item: subscribers) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withSubscribers(List<io.fabric8.knative.duck.v1beta1.SubscriberStatus> subscribers){
            if (this.subscribers != null) { _visitables.get("subscribers").removeAll(this.subscribers);}
            if (subscribers != null) {this.subscribers = new ArrayList<io.fabric8.knative.duck.v1beta1.SubscriberStatusBuilder>(); for (io.fabric8.knative.duck.v1beta1.SubscriberStatus item : subscribers){this.addToSubscribers(item);}} else { this.subscribers = null;} return (A) this;
    }

    public A withSubscribers(io.fabric8.knative.duck.v1beta1.SubscriberStatus... subscribers){
            if (this.subscribers != null) {this.subscribers.clear();}
            if (subscribers != null) {for (io.fabric8.knative.duck.v1beta1.SubscriberStatus item :subscribers){ this.addToSubscribers(item);}} return (A) this;
    }

    public Boolean hasSubscribers(){
            return subscribers != null && !subscribers.isEmpty();
    }

    public A addNewSubscriber(String message,Long observedGeneration,String ready,String uid){
            return (A)addToSubscribers(new SubscriberStatus(message, observedGeneration, ready, uid));
    }

    public ChannelableStatusFluent.SubscribersNested<A> addNewSubscriber(){
            return new SubscribersNestedImpl();
    }

    public ChannelableStatusFluent.SubscribersNested<A> addNewSubscriberLike(io.fabric8.knative.duck.v1beta1.SubscriberStatus item){
            return new SubscribersNestedImpl(-1, item);
    }

    public ChannelableStatusFluent.SubscribersNested<A> setNewSubscriberLike(int index,io.fabric8.knative.duck.v1beta1.SubscriberStatus item){
            return new SubscribersNestedImpl(index, item);
    }

    public ChannelableStatusFluent.SubscribersNested<A> editSubscriber(int index){
            if (subscribers.size() <= index) throw new RuntimeException("Can't edit subscribers. Index exceeds size.");
            return setNewSubscriberLike(index, buildSubscriber(index));
    }

    public ChannelableStatusFluent.SubscribersNested<A> editFirstSubscriber(){
            if (subscribers.size() == 0) throw new RuntimeException("Can't edit first subscribers. The list is empty.");
            return setNewSubscriberLike(0, buildSubscriber(0));
    }

    public ChannelableStatusFluent.SubscribersNested<A> editLastSubscriber(){
            int index = subscribers.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last subscribers. The list is empty.");
            return setNewSubscriberLike(index, buildSubscriber(index));
    }

    public ChannelableStatusFluent.SubscribersNested<A> editMatchingSubscriber(io.fabric8.kubernetes.api.builder.Predicate<io.fabric8.knative.duck.v1beta1.SubscriberStatusBuilder> predicate){
            int index = -1;
            for (int i=0;i<subscribers.size();i++) { 
            if (predicate.apply(subscribers.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching subscribers. No match found.");
            return setNewSubscriberLike(index, buildSubscriber(index));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            ChannelableStatusFluentImpl that = (ChannelableStatusFluentImpl) o;
            if (address != null ? !address.equals(that.address) :that.address != null) return false;
            if (conditions != null ? !conditions.equals(that.conditions) :that.conditions != null) return false;
            if (deadLetterChannel != null ? !deadLetterChannel.equals(that.deadLetterChannel) :that.deadLetterChannel != null) return false;
            if (observedGeneration != null ? !observedGeneration.equals(that.observedGeneration) :that.observedGeneration != null) return false;
            if (subscribers != null ? !subscribers.equals(that.subscribers) :that.subscribers != null) return false;
            return true;
    }


    public class AddressNestedImpl<N> extends AddressableFluentImpl<ChannelableStatusFluent.AddressNested<N>> implements ChannelableStatusFluent.AddressNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final AddressableBuilder builder;
    
            AddressNestedImpl(Addressable item){
                    this.builder = new AddressableBuilder(this, item);
            }
            AddressNestedImpl(){
                    this.builder = new AddressableBuilder(this);
            }
    
    public N and(){
            return (N) ChannelableStatusFluentImpl.this.withAddress(builder.build());
    }
    public N endAddress(){
            return and();
    }

}
    public class ConditionsNestedImpl<N> extends ConditionFluentImpl<ChannelableStatusFluent.ConditionsNested<N>> implements ChannelableStatusFluent.ConditionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ConditionBuilder builder;
        private final int index;
    
            ConditionsNestedImpl(int index,Condition item){
                    this.index = index;
                    this.builder = new ConditionBuilder(this, item);
            }
            ConditionsNestedImpl(){
                    this.index = -1;
                    this.builder = new ConditionBuilder(this);
            }
    
    public N and(){
            return (N) ChannelableStatusFluentImpl.this.setToConditions(index,builder.build());
    }
    public N endCondition(){
            return and();
    }

}
    public class DeadLetterChannelNestedImpl<N> extends KReferenceFluentImpl<ChannelableStatusFluent.DeadLetterChannelNested<N>> implements ChannelableStatusFluent.DeadLetterChannelNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final KReferenceBuilder builder;
    
            DeadLetterChannelNestedImpl(KReference item){
                    this.builder = new KReferenceBuilder(this, item);
            }
            DeadLetterChannelNestedImpl(){
                    this.builder = new KReferenceBuilder(this);
            }
    
    public N and(){
            return (N) ChannelableStatusFluentImpl.this.withDeadLetterChannel(builder.build());
    }
    public N endDeadLetterChannel(){
            return and();
    }

}
    public class SubscribersNestedImpl<N> extends io.fabric8.knative.duck.v1beta1.SubscriberStatusFluentImpl<ChannelableStatusFluent.SubscribersNested<N>> implements ChannelableStatusFluent.SubscribersNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final io.fabric8.knative.duck.v1beta1.SubscriberStatusBuilder builder;
        private final int index;
    
            SubscribersNestedImpl(int index,io.fabric8.knative.duck.v1beta1.SubscriberStatus item){
                    this.index = index;
                    this.builder = new io.fabric8.knative.duck.v1beta1.SubscriberStatusBuilder(this, item);
            }
            SubscribersNestedImpl(){
                    this.index = -1;
                    this.builder = new io.fabric8.knative.duck.v1beta1.SubscriberStatusBuilder(this);
            }
    
    public N and(){
            return (N) ChannelableStatusFluentImpl.this.setToSubscribers(index,builder.build());
    }
    public N endSubscriber(){
            return and();
    }

}


}
