package io.fabric8.knative.duck.v1beta1;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.knative.v1.URL;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import io.fabric8.knative.v1.URLBuilder;
import io.fabric8.knative.v1.URLFluentImpl;
import java.lang.StringBuffer;
import java.lang.Long;
import java.lang.Object;

public class SubscriberSpecFluentImpl<A extends io.fabric8.knative.duck.v1beta1.SubscriberSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.knative.duck.v1beta1.SubscriberSpecFluent<A>{

    private io.fabric8.knative.duck.v1beta1.DeliverySpecBuilder delivery;
    private Long generation;
    private URLBuilder replyUri;
    private URLBuilder subscriberUri;
    private String uid;

    public SubscriberSpecFluentImpl(){
    }
    public SubscriberSpecFluentImpl(io.fabric8.knative.duck.v1beta1.SubscriberSpec instance){
            this.withDelivery(instance.getDelivery()); 
            this.withGeneration(instance.getGeneration()); 
            this.withReplyUri(instance.getReplyUri()); 
            this.withSubscriberUri(instance.getSubscriberUri()); 
            this.withUid(instance.getUid()); 
    }

    
/**
 * This method has been deprecated, please use method buildDelivery instead.
 * @return The buildable object.
 */
@java.lang.Deprecated public io.fabric8.knative.duck.v1beta1.DeliverySpec getDelivery(){
            return this.delivery!=null?this.delivery.build():null;
    }

    public io.fabric8.knative.duck.v1beta1.DeliverySpec buildDelivery(){
            return this.delivery!=null?this.delivery.build():null;
    }

    public A withDelivery(io.fabric8.knative.duck.v1beta1.DeliverySpec delivery){
            _visitables.get("delivery").remove(this.delivery);
            if (delivery!=null){ this.delivery= new io.fabric8.knative.duck.v1beta1.DeliverySpecBuilder(delivery); _visitables.get("delivery").add(this.delivery);} return (A) this;
    }

    public Boolean hasDelivery(){
            return this.delivery != null;
    }

    public SubscriberSpecFluent.DeliveryNested<A> withNewDelivery(){
            return new DeliveryNestedImpl();
    }

    public SubscriberSpecFluent.DeliveryNested<A> withNewDeliveryLike(io.fabric8.knative.duck.v1beta1.DeliverySpec item){
            return new DeliveryNestedImpl(item);
    }

    public SubscriberSpecFluent.DeliveryNested<A> editDelivery(){
            return withNewDeliveryLike(getDelivery());
    }

    public SubscriberSpecFluent.DeliveryNested<A> editOrNewDelivery(){
            return withNewDeliveryLike(getDelivery() != null ? getDelivery(): new io.fabric8.knative.duck.v1beta1.DeliverySpecBuilder().build());
    }

    public SubscriberSpecFluent.DeliveryNested<A> editOrNewDeliveryLike(io.fabric8.knative.duck.v1beta1.DeliverySpec item){
            return withNewDeliveryLike(getDelivery() != null ? getDelivery(): item);
    }

    public Long getGeneration(){
            return this.generation;
    }

    public A withGeneration(Long generation){
            this.generation=generation; return (A) this;
    }

    public Boolean hasGeneration(){
            return this.generation != null;
    }

    
/**
 * This method has been deprecated, please use method buildReplyUri instead.
 * @return The buildable object.
 */
@java.lang.Deprecated public URL getReplyUri(){
            return this.replyUri!=null?this.replyUri.build():null;
    }

    public URL buildReplyUri(){
            return this.replyUri!=null?this.replyUri.build():null;
    }

    public A withReplyUri(URL replyUri){
            _visitables.get("replyUri").remove(this.replyUri);
            if (replyUri!=null){ this.replyUri= new URLBuilder(replyUri); _visitables.get("replyUri").add(this.replyUri);} return (A) this;
    }

    public Boolean hasReplyUri(){
            return this.replyUri != null;
    }

    public SubscriberSpecFluent.ReplyUriNested<A> withNewReplyUri(){
            return new ReplyUriNestedImpl();
    }

    public SubscriberSpecFluent.ReplyUriNested<A> withNewReplyUriLike(URL item){
            return new ReplyUriNestedImpl(item);
    }

    public SubscriberSpecFluent.ReplyUriNested<A> editReplyUri(){
            return withNewReplyUriLike(getReplyUri());
    }

    public SubscriberSpecFluent.ReplyUriNested<A> editOrNewReplyUri(){
            return withNewReplyUriLike(getReplyUri() != null ? getReplyUri(): new URLBuilder().build());
    }

    public SubscriberSpecFluent.ReplyUriNested<A> editOrNewReplyUriLike(URL item){
            return withNewReplyUriLike(getReplyUri() != null ? getReplyUri(): item);
    }

    
/**
 * This method has been deprecated, please use method buildSubscriberUri instead.
 * @return The buildable object.
 */
@java.lang.Deprecated public URL getSubscriberUri(){
            return this.subscriberUri!=null?this.subscriberUri.build():null;
    }

    public URL buildSubscriberUri(){
            return this.subscriberUri!=null?this.subscriberUri.build():null;
    }

    public A withSubscriberUri(URL subscriberUri){
            _visitables.get("subscriberUri").remove(this.subscriberUri);
            if (subscriberUri!=null){ this.subscriberUri= new URLBuilder(subscriberUri); _visitables.get("subscriberUri").add(this.subscriberUri);} return (A) this;
    }

    public Boolean hasSubscriberUri(){
            return this.subscriberUri != null;
    }

    public SubscriberSpecFluent.SubscriberUriNested<A> withNewSubscriberUri(){
            return new SubscriberUriNestedImpl();
    }

    public SubscriberSpecFluent.SubscriberUriNested<A> withNewSubscriberUriLike(URL item){
            return new SubscriberUriNestedImpl(item);
    }

    public SubscriberSpecFluent.SubscriberUriNested<A> editSubscriberUri(){
            return withNewSubscriberUriLike(getSubscriberUri());
    }

    public SubscriberSpecFluent.SubscriberUriNested<A> editOrNewSubscriberUri(){
            return withNewSubscriberUriLike(getSubscriberUri() != null ? getSubscriberUri(): new URLBuilder().build());
    }

    public SubscriberSpecFluent.SubscriberUriNested<A> editOrNewSubscriberUriLike(URL item){
            return withNewSubscriberUriLike(getSubscriberUri() != null ? getSubscriberUri(): item);
    }

    public String getUid(){
            return this.uid;
    }

    public A withUid(String uid){
            this.uid=uid; return (A) this;
    }

    public Boolean hasUid(){
            return this.uid != null;
    }

    public A withNewUid(String arg1){
            return (A)withUid(new String(arg1));
    }

    public A withNewUid(StringBuilder arg1){
            return (A)withUid(new String(arg1));
    }

    public A withNewUid(StringBuffer arg1){
            return (A)withUid(new String(arg1));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            SubscriberSpecFluentImpl that = (SubscriberSpecFluentImpl) o;
            if (delivery != null ? !delivery.equals(that.delivery) :that.delivery != null) return false;
            if (generation != null ? !generation.equals(that.generation) :that.generation != null) return false;
            if (replyUri != null ? !replyUri.equals(that.replyUri) :that.replyUri != null) return false;
            if (subscriberUri != null ? !subscriberUri.equals(that.subscriberUri) :that.subscriberUri != null) return false;
            if (uid != null ? !uid.equals(that.uid) :that.uid != null) return false;
            return true;
    }


    public class DeliveryNestedImpl<N> extends io.fabric8.knative.duck.v1beta1.DeliverySpecFluentImpl<SubscriberSpecFluent.DeliveryNested<N>> implements SubscriberSpecFluent.DeliveryNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final io.fabric8.knative.duck.v1beta1.DeliverySpecBuilder builder;
    
            DeliveryNestedImpl(io.fabric8.knative.duck.v1beta1.DeliverySpec item){
                    this.builder = new io.fabric8.knative.duck.v1beta1.DeliverySpecBuilder(this, item);
            }
            DeliveryNestedImpl(){
                    this.builder = new io.fabric8.knative.duck.v1beta1.DeliverySpecBuilder(this);
            }
    
    public N and(){
            return (N) SubscriberSpecFluentImpl.this.withDelivery(builder.build());
    }
    public N endDelivery(){
            return and();
    }

}
    public class ReplyUriNestedImpl<N> extends URLFluentImpl<SubscriberSpecFluent.ReplyUriNested<N>> implements SubscriberSpecFluent.ReplyUriNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final URLBuilder builder;
    
            ReplyUriNestedImpl(URL item){
                    this.builder = new URLBuilder(this, item);
            }
            ReplyUriNestedImpl(){
                    this.builder = new URLBuilder(this);
            }
    
    public N and(){
            return (N) SubscriberSpecFluentImpl.this.withReplyUri(builder.build());
    }
    public N endReplyUri(){
            return and();
    }

}
    public class SubscriberUriNestedImpl<N> extends URLFluentImpl<SubscriberSpecFluent.SubscriberUriNested<N>> implements SubscriberSpecFluent.SubscriberUriNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final URLBuilder builder;
    
            SubscriberUriNestedImpl(URL item){
                    this.builder = new URLBuilder(this, item);
            }
            SubscriberUriNestedImpl(){
                    this.builder = new URLBuilder(this);
            }
    
    public N and(){
            return (N) SubscriberSpecFluentImpl.this.withSubscriberUri(builder.build());
    }
    public N endSubscriberUri(){
            return and();
    }

}


}
