package io.fabric8.knative.eventing.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.knative.v1.URLFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.knative.v1.URL;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.knative.v1.Condition;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.knative.v1.ConditionFluent;
import io.fabric8.knative.v1.URLBuilder;
import io.fabric8.knative.v1.ConditionBuilder;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

public interface TriggerStatusFluent<A extends TriggerStatusFluent<A>> extends Fluent<A>{


    public A addToConditions(int index,Condition item);
    public A setToConditions(int index,Condition item);
    public A addToConditions(Condition... items);
    public A addAllToConditions(Collection<Condition> items);
    public A removeFromConditions(Condition... items);
    public A removeAllFromConditions(Collection<Condition> items);
    public A removeMatchingFromConditions(io.fabric8.kubernetes.api.builder.Predicate<ConditionBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildConditions instead.
 * @return The buildable object.
 */
@java.lang.Deprecated public List<Condition> getConditions();
    public List<Condition> buildConditions();
    public Condition buildCondition(int index);
    public Condition buildFirstCondition();
    public Condition buildLastCondition();
    public Condition buildMatchingCondition(io.fabric8.kubernetes.api.builder.Predicate<ConditionBuilder> predicate);
    public Boolean hasMatchingCondition(io.fabric8.kubernetes.api.builder.Predicate<ConditionBuilder> predicate);
    public A withConditions(List<Condition> conditions);
    public A withConditions(Condition... conditions);
    public Boolean hasConditions();
    public TriggerStatusFluent.ConditionsNested<A> addNewCondition();
    public TriggerStatusFluent.ConditionsNested<A> addNewConditionLike(Condition item);
    public TriggerStatusFluent.ConditionsNested<A> setNewConditionLike(int index,Condition item);
    public TriggerStatusFluent.ConditionsNested<A> editCondition(int index);
    public TriggerStatusFluent.ConditionsNested<A> editFirstCondition();
    public TriggerStatusFluent.ConditionsNested<A> editLastCondition();
    public TriggerStatusFluent.ConditionsNested<A> editMatchingCondition(io.fabric8.kubernetes.api.builder.Predicate<ConditionBuilder> predicate);
    public Long getObservedGeneration();
    public A withObservedGeneration(Long observedGeneration);
    public Boolean hasObservedGeneration();
    
/**
 * This method has been deprecated, please use method buildSubscriberURI instead.
 * @return The buildable object.
 */
@java.lang.Deprecated public URL getSubscriberURI();
    public URL buildSubscriberURI();
    public A withSubscriberURI(URL subscriberURI);
    public Boolean hasSubscriberURI();
    public TriggerStatusFluent.SubscriberURINested<A> withNewSubscriberURI();
    public TriggerStatusFluent.SubscriberURINested<A> withNewSubscriberURILike(URL item);
    public TriggerStatusFluent.SubscriberURINested<A> editSubscriberURI();
    public TriggerStatusFluent.SubscriberURINested<A> editOrNewSubscriberURI();
    public TriggerStatusFluent.SubscriberURINested<A> editOrNewSubscriberURILike(URL item);

    public interface ConditionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ConditionFluent<TriggerStatusFluent.ConditionsNested<N>>{

        
    public N and();    public N endCondition();
}
    public interface SubscriberURINested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,URLFluent<TriggerStatusFluent.SubscriberURINested<N>>{

        
    public N and();    public N endSubscriberURI();
}


}
